/**
 * OpenAmp Audio Stream
 *
 * Wilfredo Sanchez | wsanchez@apple.com
 * September 20, 1998
 **/

#import <Foundation/NSObject.h>
#import <SoundKit/NXSoundDevice.h>

@class NXPlayStream;
@class NXSoundOut;
@class NXSoundParameters;
@class NSLock;

@interface SoundStream : NSObject

{
@private
    NXPlayStream*      myPlayStream;
    NXSoundOut*        mySoundDevice;
    NXSoundParameters* myStreamParameters;

    NSLock* myPlayingLock;
    NSLock* myCounterLock;

    int myQueuedBuffersCount;
    int myRemainingBuffersCount;
}

/**
 * Inits
 **/

- (id) initWithLayer: (layer*) aLayer
        channelCount: (int   ) aChannelCount;

/**
 * Actions
 **/

- (NXSoundDeviceError) playBuffer: (const void* ) aBuffer
                             size: (unsigned int) aSize;

- (void) wait;
- (void) abort;
- (void) pause;
- (void) resume;

@end
