/**
 * Audio routines via NeXTStep's SoundKit.
 * Uses a wrapper class "SoundStream" to do the real work.
 *
 * Wilfredo Sanchez | wsanchez@apple.com
 * September 20, 1998
 **/

#import <Foundation/NSAutoreleasePool.h>

#include "common.h"
#include "sound.h"
#import "SoundDecoder.h"
#import "SoundStream.h"

#ifndef DEBUG
#define DEBUG 0
#endif

static NSAutoreleasePool* TheAutorelesePool;

/*
 * Sound-specific stuff for Rhapsody
 */

sound_device_t sound_open ()
{
    TheAutorelesePool = [[NSAutoreleasePool alloc] init];

    return [SoundStream alloc];
}

int sound_init (sound_device_t aSoundStream, layer *aLayer, int aChannelCount)
{
    SoundStream* aStream = [aSoundStream initWithLayer:aLayer channelCount:aChannelCount];

    if (aStream)
      {
        [aSoundStream resume];
        return 0;
      }
    else
        return -1;
}

int sound_write (sound_device_t aSoundStream, const void *aBuffer, size_t aSize)
{
    if ([aSoundStream playBuffer: aBuffer
                       size: (unsigned int)aSize] == NX_SoundDeviceErrorNone)
        return aSize;
    else
        return -1;
}

int sound_close (sound_device_t aSoundStream)
{
#if DEBUG
    NSLog(@"Waiting on sound stream");
#endif

    [decoder done];

    [aSoundStream wait ];
    [aSoundStream abort];

#if DEBUG
    NSLog(@"Sound stream done");
#endif

    [TheAutorelesePool release];
    [aSoundStream      release];

    return 0;
}
