/*
 *  sound-sun.c
 *
 *  System-specific audio routines for Sun (SunOS 4.x,
 *  Solaris/SPARC and Solaris/x86).
 *
 *  Created 16-Feb-97 by Johan Hagman.
 */

#include <multimedia/libaudio.h>
#ifdef SUNOS
# include <multimedia/audio_device.h>
#endif
#include "common.h"
#include "sound.h"

int
sound_init(sound_device_t audiofd, layer *info, int stereo) {
    Audio_hdr	audioinfo;
    int		samplefrq = (int)(s_freq[info->version]
			[info->sampling_frequency] * 1000.0);

    /* First pause and flush audio device */
    audio_pause(audiofd);
    audio_flush(audiofd);

    /* Get currect configuration */
    if (audio_get_play_config(audiofd, &audioinfo))
	return 1;

/*
    printf("rate %u, channels %u, samples/unit %u, bytes/unit %u, "
	"encoding %u, endian %u, data size %u\n",
	audioinfo.sample_rate, audioinfo.channels,
	audioinfo.samples_per_unit, audioinfo.bytes_per_unit,
	audioinfo.encoding, audioinfo.endian, audioinfo.data_size);
*/

    audioinfo.sample_rate = samplefrq;
    audioinfo.channels = stereo;
    audioinfo.samples_per_unit = 1;
    audioinfo.bytes_per_unit = 2;	/* 16-bit samples */
    audioinfo.encoding = AUDIO_ENCODING_LINEAR;
    audioinfo.data_size = AUDIO_UNKNOWN_SIZE;

    /* Initialize audio device */
    if (audio_set_play_config(audiofd, &audioinfo))
	return 1;

    audio_resume(audiofd);
    return 0;
}

sound_device_t
sound_open() {
    return(open("/dev/audio", O_WRONLY));
}

int
sound_close(sound_device_t audiofd) {
    return(close(audiofd));
}

int
sound_write(sound_device_t audiofd, const void *buffer, size_t count) {
    return(write(audiofd, buffer, count));
}
