#import "AlbumCtr.h"
#import <AppKit/NSApplication.h>
#import <AppKit/NSGraphics.h>
#import <AppKit/NSMatrix.h>
#import <AppKit/NSFont.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSBundle.h>		/* LocalizedString */
#import <AppKit/NSPanel.h>		/* NSRunAlertPanel() */
#import <AppKit/NSPasteboard.h>
#import <AppKit/NSWorkspace.h>
#import <Foundation/NSNotification.h>
#import <Foundation/NSAutoreleasePool.h>
#import <stdio.h>
#import <libc.h>
#import "TACommon.h"
#import "PhotoCell.h"
#import "ImageInfoNode.h"
#import "PrefControl.h"
#import "AlertShower.h"

#define  MiniIcon	@"TAdoc.tiff"
#define  DiffStep	18.0
#define  MinWinXSIZE	(P_Width * 2)
#define  MinWinYSIZE	P_Height
#define  MinResizeXSIZE	(P_Width * 2 + 30.0)
#define  MinResizeYSIZE	(MinWinYSIZE + 120.0)
#define  ScreenBottomMGN	20.0
#ifdef  __APPLE__  /* MacOSX */
# undef  ScreenRightMGN
# define  ScreenTopMGN		30.0
# define  X_Bias		29.0
# define  Y_Bias		115.0
#else
# define  ScreenRightMGN	72.0	/* 64 + 8 */
# define  ScreenTopMGN		10.0
# define  X_Bias		22.0
# define  Y_Bias		123.0
#endif /* MacOSX */


@implementation AlbumCtr

+ (void)initialize
{
	[self clearPasteboard];
}

/* Local Method */
- (void)setInfoFont:(NSFont *)cFont
{
	[pathText setFont:cFont];
	[sizeText setFont:cFont];
	[memoText setFont:cFont];
}


- (void)setInfoToCell
{
	int	i, j, totalnum = 0;
	PhotoCell *v;
	ImageInfoNode *p;

	for (i = 0; i < row; i++)
		for (j = 0; j < col; j++) {
			v = [albumview cellAtRow:i column:j];
			p = [tadoc imageInfoAtRow:i column:j];
			/* If p is nil, it is a padding cell.
			   Empty (dummy) cell has one entry of ImageInfoNode.
			 */
			[v setInfo:p];
			if (p)
				[v setTag:totalnum++];
		}
}

- (id)init:(id)doc withName:(NSString *)fileName
{
	NSRect rect;
	NSString *fn;
	NSSize protoSize;
	NSSize sz, spcSize;
	static int untitlecnt = 0;

	tadoc = doc;
	sz = [doc thumbSize];
	thwidth = sz.width + M_Width;
	thheight = sz.height + M_Height;
	[NSBundle loadNibNamed:@"AlbumWin.nib" owner:self];
	[window setReleasedWhenClosed:YES];
	[window setMiniwindowImage:[NSImage imageNamed:MiniIcon]];
	if (fileName)
		fn = fileName;
	else {
		NSString *ut = NSLocalizedString(@"Untitled", Untitled);
		fn = [NSString stringWithFormat:@"~/%@%d", ut, ++untitlecnt];
	}
	[window setTitleWithRepresentedFilename: fn];

	[scrollview setHasHorizontalScroller:YES];
	[scrollview setHasVerticalScroller:YES];
	rect = [scrollview frame];
	row = [tadoc rows];
	col = [tadoc columns];
	isNew = NO;
	inLoop = NO;
	albumview = [[NSMatrix alloc] initWithFrame: rect
		mode: NSRadioModeMatrix
		cellClass:[PhotoCell class]
		numberOfRows: row numberOfColumns: col];
	spcSize.width = IntrCellSpc;
	spcSize.height = IntrCellSpc;
	[albumview setIntercellSpacing: spcSize];
	protoSize.width = thwidth;
	protoSize.height = thheight;
	[albumview setCellSize: protoSize];
	[albumview sizeToCells];
	[albumview setTabKeyTraversesCells:YES];
	[albumview setTarget: self];
	[albumview setAction: @selector(clickAct:)];
	[albumview setDoubleAction: @selector(doubleClickAct:)];
	[albumview setDelegate: self];
	[window setDelegate: self];
	[window registerForDraggedTypes:
		[NSArray arrayWithObject: NSFilenamesPboardType]];

	[self setInfoToCell];
	[scrollview setLineScroll:(thheight + IntrCellSpc)];
	[albumview setBackgroundColor: [NSColor darkGrayColor]];
	[scrollview setDocumentView: albumview];
	[self setInfoFont:[thePreference currentFont]];

	[[NSNotificationCenter defaultCenter] addObserver:self
		selector:@selector(changeCellFont:)
		name:FontDidChange object:nil];
	[[NSNotificationCenter defaultCenter] addObserver:self
		selector:@selector(changeTitleSuffix:)
		name:SuffixDidChange object:nil];

	return self;
}

- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	[super dealloc];
}

- (id)window
{
	return window;
}

- (id)view
{
	return albumview;
}

- (void)setIsNew:(BOOL)flag
{
	isNew = flag;
}

- (BOOL)isNew
{
	return isNew;
}

- (void)changeCellFont:(NSNotification *)aNotification
{
	int i, j;

	[self setInfoFont:[thePreference currentFont]];
	for (i = 0; i < row; i++)
		for (j = 0; j < col; j++)
			[[albumview cellAtRow:i column:j] resetFont];
	[albumview display];
}

- (void)changeTitleSuffix:(NSNotification *)aNotification
{
	int i, j;

	for (i = 0; i < row; i++)
		for (j = 0; j < col; j++)
			[[albumview cellAtRow:i column:j] resetTitle];
	[albumview display];
}


- locateWindow: (int)width : (int)height by:(int)is_init : (NSPoint *)atpoint;
	/* width, height  ᡼礭 */
{
	NSSize screenSize;
	NSSize req;	/* ᡼ݤɽǤ礭 */
	NSSize rsmin;	/* ꥵκǾ */
	NSRect orig;	/* ߤΥɥξ */
	NSRect wrect;
	double xp, yp;	/* ɥ */
	double yh;
	static int winCounter = 6; /* because small window is under the menu */

	screenSize = [[NSScreen mainScreen] frame].size;
#ifdef ScreenRightMGN
	screenSize.width -= ScreenRightMGN;
#endif
	screenSize.height -= ScreenTopMGN;
	req.width = ((MinWinXSIZE > width) ? MinWinXSIZE : width) + X_Bias;
	req.height = ((MinWinYSIZE > height) ? MinWinYSIZE : height) + Y_Bias;
	rsmin.width = (req.width < MinResizeXSIZE)
			? req.width : MinResizeXSIZE;
	rsmin.height = (req.height < MinResizeYSIZE)
			? req.height : MinResizeYSIZE;
	wrect.size = req;

	if (is_init == loc_RESZ) {
		orig = [window frame];
		wrect.origin = orig.origin;
		if (req.width > orig.size.width)
			wrect.size.width = orig.size.width;
		if (req.height >= orig.size.height)
			wrect.size.height = orig.size.height;
		else
			wrect.origin.y += orig.size.height - wrect.size.height;
		if (orig.size.width < rsmin.width)
			rsmin.width = orig.size.width;
		if (orig.size.height < rsmin.height)
			rsmin.height = orig.size.height;
	}else {
		if (is_init == loc_INIT || atpoint == NULL) {
			int xm = 7, ym = 9;
			if (screenSize.height <= 600.0)
				xm = 5, ym = 7;
			xp = (req.width > screenSize.width)
				? 0.0 : (120.0 + (winCounter % xm) * DiffStep);
			yp = (req.height > screenSize.height)
				? 0.0 : (20.0 + (winCounter % ym) * DiffStep);
		}else { /* loc_SPEC */
			double w;
			xp = atpoint->x;
			yp = screenSize.height - atpoint->y;
			if (xp < 0) xp = 0.0;
			else if (xp > (w = screenSize.width - MinResizeXSIZE))
				xp = w;
			if (yp < 0) yp = 0.0;
			else if (yp > (w = screenSize.height - MinResizeYSIZE))
				yp = w;
		}
		if (xp + req.width > screenSize.width)
			wrect.size.width = screenSize.width - xp;
		yh = screenSize.height - ScreenBottomMGN;
		if (yp + req.height > yh)
			wrect.size.height = yh - yp;
		wrect.origin.x = xp;
		yp = screenSize.height - wrect.size.height - yp;
		wrect.origin.y = (yp > ScreenBottomMGN) ? yp : ScreenBottomMGN;
		winCounter++;
	}

	[window setFrame:wrect display:NO];
	[window setMaxSize:req];
	[window setMinSize:rsmin];
	return self;
}

/* Local Method*/
- (void)castNotification:(BOOL)ok
{
	[[NSNotificationCenter defaultCenter]
		postNotificationName:AlbumDidBuild
		object:(ok ? tadoc: nil)];
}

/* Local Method*/
- (void)showOneByOne:(id)sender
{
	static int i, j;
	NSAutoreleasePool *subpool;
	id cell;
	NSRect fr;
	NSPoint scp;
	float	dif;

	if (!inLoop) {	/* Begining of Loop */
		NSString *msg;
		i = j = 0;
		msg = NSLocalizedString(@"Making new album.  Wait.", MakingAlbum);
		[pathText setStringValue:msg];
		[stopButton setEnabled:YES];
		[stopButton setTransparent:NO];
		goto goNEXT;	// important to delay notification
	}

	subpool = [[NSAutoreleasePool alloc] init];
	cell = [albumview cellAtRow:i column:j];
	fr = [albumview cellFrameAtRow:i column:j];
	[albumview selectCellAtRow:i column:j];
	[cell showIconImage];
	[albumview displayRect:fr];
	[subpool release];

	if (++j >= col) {
		j = 0;
		if (++i >= row) {	/* End Of Loop */
			[stopButton setEnabled:NO];
			[stopButton setTransparent:YES];
			[pathText setStringValue:@""];
			[albumview selectCellAtRow:0 column:0];
			[self clickAct:albumview];
			inLoop = NO;
			[self castNotification:YES];
			return;
		}
		fr = [albumview visibleRect];
		dif = thheight * (i+1) + IntrCellSpc * i
			- (fr.origin.y + fr.size.height);
		scp.y = fr.origin.y;
		if (dif > 0.0) scp.y += dif;
		scp.x = 0.0;
		[[scrollview contentView] scrollToPoint:scp];
		[scrollview reflectScrolledClipView:[scrollview contentView]];
	}
goNEXT:
	inLoop = YES;
	[self performSelector:@selector(showOneByOne:) 
		withObject:self afterDelay: 30 / 1000.0];
}

- locateWindow
{
	NSRect rect, fr;
	NSPoint	scp;
	int	i, j, dif;

	rect = [albumview frame];
	[self locateWindow: rect.size.width : rect.size.height by:loc_INIT : NULL];
	[window makeKeyAndOrderFront:self];
	// PSWait();
	// [window display];
	if (isNew) {
		[self showOneByOne:nil];	/* Begining of Loop */
		return self;
	}

	for (i = 0; ; ) {
		for (j = 0; j < col; j++) {
			NSAutoreleasePool *subpool;
			id cell;
			subpool = [[NSAutoreleasePool alloc] init];
			cell = [albumview cellAtRow:i column:j];
			fr = [albumview cellFrameAtRow:i column:j];
			[albumview selectCellAtRow:i column:j];
			[cell showIconImage];
			[albumview displayRect:fr];
			[subpool release];
		}
		if (++i >= row)
			break;
		fr = [albumview visibleRect];
		dif = thheight * (i+1) + IntrCellSpc * i
			- (fr.origin.y + fr.size.height);
		scp.y = fr.origin.y;
		if (dif > 0.0) scp.y += dif;
		scp.x = 0.0;
		[[scrollview contentView] scrollToPoint:scp];
		[scrollview reflectScrolledClipView:[scrollview contentView]];
	}
	[pathText setStringValue:@""];
	[albumview selectCellAtRow:0 column:0];
	[self clickAct:albumview];
	return self;
}

- (NSString *)displayMessage:(NSString *)msg
{
	NSString *p = [pathText stringValue];
	[pathText setStringValue:(msg ? msg : @"")];
	[pathText display];
	PSWait();
	return (p && [p length] > 0) ? p : nil;
}

- (void)print: sender
{
	NSMatrixMode prevmode = [albumview mode];
	if (prevmode == NSRadioModeMatrix) {
		id cel = [albumview selectedCell];
		[albumview setMode: NSListModeMatrix];
		[albumview deselectSelectedCell];
		[albumview print: sender];
		[albumview setMode: prevmode];
		[cel performClick: self];
	}else
		[albumview print: sender];
}

- (ImageInfoNode *)selectedCellInfo
{
	id	cel = [albumview selectedCell];
	return (cel == nil) ? nil : [cel info];
}

- (void)memoChange:sender
{
	ImageInfoNode *node = [self selectedCellInfo];
	if (node == nil) {
		NSBeep();
		return;
	}
	[node setComment:[memoText stringValue]];
	[self setDocumentEdited:YES];
}


- (void)clickAct:sender
{
	id	cel;
	ImageInfoNode *node;
	long	size;
	NSString *s, *t;

	if (!(cel = [sender selectedCell])
		|| !(node = [cel info]) || [node filename] == nil) {
		[pathText setStringValue:@""];
		[sizeText setStringValue:@""];
		[memoText setStringValue:@""];
		return;
	}
	[window makeFirstResponder:sender];	// Explicit
	if (!(s = [node filename])) s = @"";
	if ([node isAbsolute])
		[pathText setStringValue:s];
	else if ((t = [tadoc pathRelativeToAlbum:s]) != nil)
		[pathText setStringValue:t];
	else
		[pathText setStringValue:s];
	if ((s = [node comment]) != nil)
		[memoText setStringValue:s];
	else
		[memoText setStringValue:@""];
	if ((size = [node size]) != 0) {
		[sizeText setStringValue:[node sizeString]];
	}else
		[sizeText setStringValue:@""];
}

- (void)doubleClickAct:sender
{
	PhotoCell *cel;
	NSPoint pt;
	int	tag;
	NSString *fnam;

	if ((cel = [sender selectedCell]) == nil
	|| (fnam = [cel filename]) == nil)
		return;
	if (access([fnam cString], R_OK) != 0) {
		[ErrAlert runAlert:fnam :(int)Err_ACCESS];
		return;
	}
	tag = [cel tag];
	pt.x = (tag % col) * (thwidth + IntrCellSpc);
	pt.y = (tag / col + 1) * (thheight + IntrCellSpc);
	[[NSWorkspace sharedWorkspace]
		openFile: fnam
		fromImage: [cel iconImage]
		at: pt
		inView: albumview];
}

- (void)confirmAndClose:(id)sender
{
	if ([self isDocumentEdited]) {
		NSString *mesg, *syes, *snon, *fnam;
		int	ans;

		[window makeKeyAndOrderFront:self];
		syes = NSLocalizedString(@"Yes", YES);
		snon = NSLocalizedString(@"No", NO);
		mesg = NSLocalizedString(@"Do you want to save?", WantSave);
		if ((fnam = [tadoc filename]) == nil)
			fnam = NSLocalizedString(@"Untitled", Untitled);
		do {
			ans = NSRunAlertPanel(@"", @"%@\n%@", syes, snon, nil, fnam, mesg);
			if (ans != NSAlertDefaultReturn)
				break;
		}while ([tadoc saveDoc:sender] == nil);
	}
	[window setDelegate:nil];
	[tadoc releaseSelf];
	[self release];
}

/* delegate methods */
- (BOOL)windowShouldClose:(id)sender
{
	NSString *mesg, *syes, *snon, *sccl;
	int	ans;

	if (inLoop) {
		syes = NSLocalizedString(@"Abort", Abort);
		snon = NSLocalizedString(@"Continue", CONTINUE);
		mesg = NSLocalizedString(@"Do you want to abort?", WantAbort);
		ans = NSRunAlertPanel(@"", mesg, syes, snon, nil);
		if (ans != NSAlertDefaultReturn)
			return NO;
		[NSObject cancelPreviousPerformRequestsWithTarget:self
			selector:@selector(showOneByOne:) object:self];
		inLoop = NO;
		[self castNotification:NO];
	}else if ([self isDocumentEdited]) {
		syes = NSLocalizedString(@"Yes", YES);
		snon = NSLocalizedString(@"No", NO);
		sccl = NSLocalizedString(@"Cancel", CANCEL);
		mesg = NSLocalizedString(@"Do you want to save?", WantSave);
		ans = NSRunAlertPanel(@"", mesg, syes, snon, sccl);
		if (ans == NSAlertOtherReturn)
			return NO;
		else if (ans == NSAlertDefaultReturn)
			if ([tadoc saveDoc:sender] == nil)
				return NO;
	}

	[window setDelegate:nil];
	[tadoc releaseSelf];
	[self release];
	return YES;
}

/* delegate methods */
- (void)windowDidBecomeMain:(NSNotification *)aNotification
{
	[tadoc didBecomeMain:self];
}

@end
