/*
	AlertShower.m	1997-12-28
		by T.Ogihara (ogihara@seg.kobe-u.ac.jp)
*/

#import  "AlertShower.h"
#import  <stdio.h>
#import  <stdlib.h>
#import  <libc.h>
#import  <objc/objc.h>
#import  <Foundation/NSString.h>
#import  <Foundation/NSBundle.h>	/* LocalizedString */
#import  <AppKit/NSPanel.h>		/* NSRunAlertPanel() */
#import  <AppKit/NSGraphics.h>		/* NSPing() */
#import  "TACommon.h"


/* extern */ AlertShower *ErrAlert, *WarnAlert;

@implementation AlertShower

+ (void)setGlobal
{
	ErrAlert = [[AlertShower alloc]
		initWithTitle:NSLocalizedString(@"ERROR", ERROR)];
	WarnAlert = [[AlertShower alloc]
		initWithTitle:NSLocalizedString(@"WARNING", ERROR)];
}

- initWithTitle:(NSString *)str
{
	[super init];
	title = [str retain];
	return self;
}


static NSString *err_message(int err)
{
	switch (err) {
	case Err_OPEN:
		return NSLocalizedString(@"Can't open file", Err_OPEN);
	case Err_NOFILE:
		return NSLocalizedString(@"There is no file", Err_NOFILE);
	case Err_ACCESS:
		return NSLocalizedString(@"Can't access to file", Err_ACCESS);
	case Err_NODIR:
		return NSLocalizedString(@"No such directory", Err_NODIR);
	case Err_FORMAT:
		return NSLocalizedString(@"Illegal image format", Err_FORMAT);
	case Err_MEMORY:
		return NSLocalizedString(
			@"Can't get working memory", Err_MEMORY);
	case Err_ILLG:
		return NSLocalizedString(
			@"Illegal information included", Err_ILLG);
	case Err_IMPLEMENT:
		return NSLocalizedString(
			@"Unsupported image format", Err_IMPLEMENT);
	case Err_SAVE:
		return NSLocalizedString(
			@"Can't write into file", Err_SAVE);
	case Err_OPR_IMPL:
		return NSLocalizedString(
			@"Can't apply this operation", Err_OPR_IMPL);
	case Err_REGEXP:
		return NSLocalizedString(
			@"Illegal regular expression", Err_REGEXP);
	case Err_NODIR_NAME:
		return NSLocalizedString(@"Specify directory", Err_NODIR_NAME);
	case Err_NOALB_NAME:
		return NSLocalizedString(
			@"No name for new album", Err_NOALB_NAME);
	case Err_ALB_ABSPATH:
		return NSLocalizedString(
			@"Don't specify absolute path", Err_ALB_ABSPATH);
	case Err_ALB_USEABS:
		return NSLocalizedString(
			@"Specify absolute path", Err_ALB_USEABS);

	case Warn_Traverse:
		return NSLocalizedString(@"Traversing directories", Warn_Trav);

	default:
		break;
	}
	return nil;
}

- (void)runAlert:(NSString *)filename :(int)err
{
	if (filename == nil)
		NSRunAlertPanel(title, err_message(err), @"", nil, nil);
	else
		NSRunAlertPanel(title, @"%@ :\n%@",
			@"", nil, nil, filename, err_message(err));
}

@end
