/*
    This code is originally for ToyViewer.
    Tuned for ToyAlbum 0.4 by T.Ogihara
*/

#import "BundleLoader.h"
#import <Foundation/NSBundle.h>

struct _load_tab {
	NSString	*resource;
	NSString	*classname;
};
static struct _load_tab loadtab[BundleNum] = {
	{ @"MakeAlbum",	@"TADocMaker" },
	{ @"Reduction",	@"HTMLSaver" },
	{ @"Shrinker",	@"ImageShrinker" }
};
static Class classObj[BundleNum];

@implementation BundleLoader

+ (Class)loadClass:(int)classid
{
	NSBundle *bundle;
	NSString *path;

	if (classObj[classid])
		return classObj[classid];

	/* Load "???.bundle" */
	bundle = [NSBundle mainBundle];
	path = [bundle pathForResource:loadtab[classid].resource
			ofType:@"bundle"];
	bundle = [NSBundle bundleWithPath: path];
	if (bundle == nil) /* ERROR */
		return nil;
	classObj[classid] = [bundle classNamed:loadtab[classid].classname];
	return classObj[classid];
}

+ (id)loadAndNew:(int)classid
{
	return [[[self loadClass:classid] alloc] init];
}

@end
