#import "DirTraverser.h"
#import <Foundation/NSFileManager.h>
#import "../TACommon.h"

static NSFileManager	*fmanager = nil;
static NSString *skipExtension[] = {
	@"rtfd", @"htmld", @"app", @"bundle", @"mbox",
	@"alb",		/* ToyAlbum */
	@"nib", @"nib~", /* InterfaceBuilder */
	@"diagram2",	/* Diagram! */
	@"quantrix",	/* LQ */
	@"concur",	/* LightShow */
	@"pkg",		/* Installer */
	nil
};

@implementation DirTraverser

+ (void)initialize
{
	if (fmanager == nil)
		fmanager = [NSFileManager defaultManager];
}

- (id)initWithPath:(NSString *)path
{
	NSString *ex;
	BOOL	isdir = NO;
	int	i;

	[super init];
	mypath = [path retain];
	subdirs = nil;
	checksub = NO;
	if ([fmanager fileExistsAtPath:path isDirectory:&isdir] == NO
			|| isdir == NO)
		goto CANCEL;
	ex = [path pathExtension];
	for (i = 0; skipExtension[i]; i++) {
		if ([ex isEqualToString: skipExtension[i]])
			goto CANCEL;
	}
	return self;
CANCEL:
	[self release];
	return nil;
}

- (void)dealloc
{
	[mypath release];
	[subdirs release];
	[super dealloc];
}

- (NSString *)pathname
{
	return mypath;
}

- (id)currentObj
{
	if (subdirs == nil || [subdirs count] == 0)
		return self;
	return [[subdirs objectAtIndex: 0] currentObj];
}

- (NSString *)nextPath
{
	if (checksub == NO) {
		NSArray *cont;
		id	obj, item, fn;
		int	i, n;

		checksub = YES;
		cont = [fmanager directoryContentsAtPath:mypath];
		if (cont == nil || (n = [cont count]) == 0)
			return mypath;
		if (n > 1)
			cont = [cont sortedArrayUsingSelector:
					@selector(caseInsensitiveCompare:)];
		subdirs = [[NSMutableArray alloc] initWithCapacity:1];
		for (i = 0; i < n; i++) {
			fn = [cont objectAtIndex: i];
			item = [mypath stringByAppendingPathComponent:fn];
			obj = [[[self class] alloc] initWithPath:item];
			if (obj) {
				[subdirs addObject:obj];
				[obj release];
			}
		}
	}
	/* if subdirs == nil: return nil as next path.
	   if [subdirs count] == 0: return mypath as next path. */

	if (subdirs == nil)
		return nil;
	while ([subdirs count] > 0) {
		NSString *nextp = [[subdirs objectAtIndex: 0] nextPath];
		if (nextp != nil)
			return nextp;
		[subdirs removeObjectAtIndex: 0];
	}
	[subdirs release];
	subdirs = nil;
	return mypath;
}

@end


#ifdef ALONE
/* cc -DALONE -o trav DirTraverser.m -framework AppKit */
#import  <Foundation/NSAutoreleasePool.h>
#import  <stdio.h>
int main(void)
{
	id trav, str;
	char buf[256];
        NSAutoreleasePool *subpool = [[NSAutoreleasePool alloc] init];
	gets(buf);
	trav = [[DirTraverser alloc] initWithPath:
			[NSString stringWithCString:buf]];
	if (trav == nil) {
		printf("Err: %s is not a directory\n", buf);
		return 1;
	}
	while ((str = [trav nextPath]) != nil)
		printf("%s\n", [str cString]);
	[trav release];
	[subpool release];
	return 0;
}
#endif
