#import "StrArraySorter.h"
#import <Foundation/NSArray.h>
#import <Foundation/NSFileManager.h>
#import <AppKit/NSPanel.h>	/* NSRunAlertPanel() */
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import <libc.h>
#import <sys/types.h>
#import <sys/stat.h>
#import <sys/file.h>
#import "../TACommon.h"
#import "Regexp.h"

#define  MAXPATHLENGTH	512

static char curDir[MAXPATHLENGTH];

@implementation StrArraySorter

- (id)init
{
	[super init];
	regx = nil;
	accessTypes = nil;
	ignoreCase = YES;
	curDir[0] = 0;
	return self;
}

- (void)dealloc
{
	[regx release];
	[accessTypes release];
}

- (void)setRegExp:(Regexp *)exp
{
	[regx release];
	regx = [exp retain];
}

- (void)setAccessTypes:(NSArray *)arr
{
	[accessTypes release];
	accessTypes = [arr retain];
}

- (void)setIgnoreCase:(BOOL)flag
{
	ignoreCase = flag;
}

- (void)setIgnoreDottedFiles:(BOOL)flag
{
	ignoreDotted = flag;
}

- (void)setDirectoryPath:(NSString *)str
{
	strcpy(curDir, [str cString]);
	/* With this directory path, strings could be sorted by file date */
}

static int sort_by_date(id fn1, id fn2, void *context)
{
	struct stat	buf;
	long tm1, tm2;
	char tmp[MAXPATHLENGTH];
	char *pp, *q;

	for (pp = tmp, q = curDir; *q; )
		*pp++ = *q++;
	*pp++ = '/';
	strcpy(pp, [fn1 cString]);
	if (stat(tmp, &buf) != 0) tm1 = 0L;
	else tm1 = (long)buf.st_mtime;
	strcpy(pp, [fn2 cString]);
	if (stat(tmp, &buf) != 0) tm2 = 0L;
	else tm2 = (long)buf.st_mtime;

	if (tm1 > tm2)
		return (context ? NSOrderedDescending : NSOrderedAscending);
	else if (tm1 < tm2)
		return (context ? NSOrderedAscending : NSOrderedDescending);
	return NSOrderedSame;
}

- (NSArray *)sortArray:(NSArray *)dirname method:(int)method
{
	NSArray	*names = nil;
	NSMutableArray	*marr;
	int	n, i;

	if ((n = [dirname count]) == 0)
		return nil;
	marr = [NSMutableArray arrayWithCapacity: (regx ? 1 : n)];
	for (i = 0; i < n; i++) {
		NSString *fn = [dirname objectAtIndex: i];
		NSString *ex = [fn pathExtension];
		if ([ex length] <= 0)
			continue;
		if (ignoreDotted && [fn characterAtIndex:0] == '.')
			continue;
		if (regx && ![regx match:fn ignoreCase:ignoreCase])
			continue;
		if (accessTypes
		&& [accessTypes indexOfObject: ex] == NSNotFound)
			continue;
		[marr addObject: fn];
	}
	if ([marr count] == 0)
		return nil;

	switch (method) {
	case Sort_Name: /* Sort by Name : case insensitive  */
		names = [marr sortedArrayUsingSelector:
				@selector(caseInsensitiveCompare:)];
		break;
	case Sort_NameC: /* Sort by Name : case sensitive */
		names = [marr sortedArrayUsingSelector:@selector(compare:)];
		break;
	case Sort_Date: /* Sort by Data */
		names = [marr sortedArrayUsingFunction:sort_by_date 
				context:(void *)0];
		break;
	case Sort_DateR: /* Sort by Data : Reverse */
		names = [marr sortedArrayUsingFunction:sort_by_date 
				context:(void *)1];
		break;
	}
	return names;
}

@end
