#import "TADocMaker.h"
#import <AppKit/NSApplication.h>
#import <AppKit/NSColor.h>
#import <Foundation/NSFileManager.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSData.h>
#import <Foundation/NSBundle.h>	/* LocalizedString */
#import <AppKit/NSPanel.h>	/* NSRunAlertPanel() */
#import <AppKit/NSImage.h>
#import <AppKit/NSPasteboard.h>
#import <stdio.h>
#import <stdlib.h>
#import "../TACommon.h"
#import "../TAController.h"
#import "../TADocument.h"
#import "../ImageInfoNode.h"
#import "../AlertShower.h"
#import "../ModeDisplay.h"
#import "../PrefControl.h"
#import "StrArraySorter.h"
#import "TwinSliderCtrl.h"
#import "Regexp.h"
#import "DirTravCtrl.h"

@implementation TADocMaker (MakeCtrl)

/* Local Method */
- (id)getAlbums:(int)kind inSubdirs:(NSString *)dirname
{
	NSArray *cont, *subs;
	NSMutableArray *ma;
	NSString *obj, *path, *ss, *sufx;
	int	n, i, sn, j;
	BOOL	isdir;
	NSFileManager *manager = [NSFileManager defaultManager];

	ma = [NSMutableArray arrayWithCapacity:1];
	cont = [manager directoryContentsAtPath: dirname];
	sufx = (kind == A_Album) ? Suffix : HTMLDirSuffix;
	n = [cont count];
	for (i = 0; i < n; i++) {
		obj = [cont objectAtIndex:i];
		path = [dirname stringByAppendingPathComponent:obj];
		isdir = NO;
		if (![manager fileExistsAtPath:path isDirectory:&isdir]
			|| !isdir)
			continue;
		subs = [manager directoryContentsAtPath:path];
		sn = [subs count];
		for (j = 0; j < sn; j++) {
			ss = [subs objectAtIndex:j];
			if ([[ss pathExtension] isEqualToString:sufx])
				[ma addObject:
				    [obj stringByAppendingPathComponent:ss]];
		}

	}
	return ma;
}

/* Local Method */
- (id)sortContentsOfDir:(NSString *)dirname
{
	StrArraySorter *sorter;
	NSAutoreleasePool *subpool;
	NSArray *names;
	id	cont, files = nil;
	int	sortmethod;
	static NSArray *imagetypes = nil;	/* array of suffixes */

	if (imagetypes == nil)
		imagetypes = [NSImage imageFileTypes];
	subpool = [[NSAutoreleasePool alloc] init];
	sorter = [[StrArraySorter alloc] init];
	files = cont = [[NSFileManager defaultManager]
					directoryContentsAtPath: dirname];
	if (incflag || traversing) {
		NSString *myname = nil;
		NSMutableArray *types = [imagetypes mutableCopy];
		if (!isHTML)
			[types addObject:Suffix];
		[types addObject:HTMLDirSuffix];
		[sorter setAccessTypes:types];
		if (newNamePath)
			myname = [newNamePath lastPathComponent];
		if (myname) {
			files = [cont mutableCopy];
			[files removeObject:myname];
		}
	}else
		[sorter setAccessTypes:imagetypes];

	[sorter setIgnoreDottedFiles: ![thePreference showDottedFiles]];
	[sorter setDirectoryPath:dirname];
	if (regx) {
		[sorter setRegExp:regx];
		[sorter setIgnoreCase: [caseSW state]];
	}
#ifdef WITH_SORT_SW
	sortmethod = [sortSW selectedTag];
#else
	sortmethod = [thePreference defaultSorting];
#endif
	names = [sorter sortArray:files method:sortmethod];
	if ((incflag || traversing) && relmod == m_relative) {
		id marr = [self getAlbums:(isHTML ? A_HTML : A_Album)
				inSubdirs:dirname];
		if ([marr count] > 0) {
			marr = [sorter sortArray:marr method:sortmethod];
			names = (names == nil) ? marr
				: [names arrayByAddingObjectsFromArray:marr];
		}
	}
	[names retain];
	[sorter release];
	[subpool release];
	return [names autorelease];
}

/* Local Method */
- (id)contentsOfAbsDir:(NSString *)dirname
{
	StrArraySorter *sorter;
	NSAutoreleasePool *subpool;
	NSArray *names;
	id	fs;
	int	sortmethod;

	subpool = [[NSAutoreleasePool alloc] init];
	sorter = [[StrArraySorter alloc] init];
	fs = [[NSFileManager defaultManager] directoryContentsAtPath: dirname];
	[sorter setAccessTypes:
		[NSArray arrayWithObject:(isHTML ? HTMLDirSuffix : Suffix)]];
	[sorter setIgnoreDottedFiles: ![thePreference showDottedFiles]];
	[sorter setDirectoryPath:dirname];
	sortmethod = [thePreference defaultSorting];
	names = [sorter sortArray:fs method:sortmethod];
	[names retain];
	[sorter release];
	[subpool release];
	return [names autorelease];
}

- (BOOL)makeAlbumIn:(NSString *)dirname newName:(NSString *)newName
/* This method is used with newName := newNamePath
	Single Directory:	all mode
	Traverse Directories:	relative mode (1,2) only
   Traversing with absolute mode:
	newName := absolute path in which album is created
*/
{
	TADocument *doc;
	NSArray *names, *trdirs;
	NSString *filename, *abspath = nil;
	NSFileManager *manager = [NSFileManager defaultManager];
	BOOL	isdir;

	if (relmod == m_relative) { /* Relative 1 */
		/* Note: newName may not be absolute nor nil */
		filename = [dirname stringByAppendingPathComponent:newName];
	}else if (relmod == m_relative_p) { /* Relative 2 */
		filename = (newName == nil) ? dirname
			: [[dirname stringByDeletingLastPathComponent]
				stringByAppendingPathComponent:newName];
	}else /* Absolute */
		filename = newName;
	if (filename) {
		if ([[filename pathExtension] isEqualToString:Suffix])
			abspath = [filename stringByDeletingPathExtension];
		else {
			abspath = filename;
			filename = [filename
				stringByAppendingPathExtension:Suffix];
		}
		isdir = NO;
		if (![manager fileExistsAtPath:abspath isDirectory:&isdir]
			|| !isdir)
			abspath = nil;
		if ([manager fileExistsAtPath:filename]) {
			NSString *canc, *cont, *mesg;
			int result;
			canc = NSLocalizedString(@"Cancel", CANCEL);
			cont = NSLocalizedString(@"Continue", CONTINUE);
			mesg = NSLocalizedString(@"Album \'%@\' is already there.", SameName);
			result = NSRunAlertPanel(AppName, mesg,
				cont, canc, nil, [filename lastPathComponent]);
			if (result == NSAlertAlternateReturn)
				return NO;
		}
	}

	if ((names = [self sortContentsOfDir:dirname]) == nil) {
		if (!traversing)
			[ErrAlert runAlert:dirname : Err_NOFILE];
	}
	if (traversing && abspath) // traverse --> incflag = YES
		trdirs = [self contentsOfAbsDir:abspath];
	else
		trdirs = nil;
	if (names == nil && trdirs == nil)
		return NO;

	doc = [[TADocument alloc] init];
	[doc setController: theController];
	[doc setMode:relmod columns:colnum size:thumbsz];
	if (trdirs)
		[doc addImageInfoNodes:trdirs in:abspath asMode:m_relative_p];
	[doc setFilename: filename];
	[doc openDirectory:dirname files:names];
	[theController newWindow:doc];
	return YES;
}

/* Local Method */
- (BOOL)makeDirectories:(NSString *)path
{
	static NSFileManager *manager = nil;
	BOOL isdir;

	if (manager == nil)
		manager = [NSFileManager defaultManager];
	isdir = NO;
	if ([manager fileExistsAtPath:path isDirectory:&isdir])
		return YES;
	if (![self makeDirectories:[path stringByDeletingLastPathComponent]])
		return NO;
	return [manager createDirectoryAtPath:path attributes:nil];
}

- (BOOL)makeAlbumFor:(NSString *)travdir
{
	int	len;
	NSString *path;

	if (relmod != m_absolute)
		return [self makeAlbumIn:travdir newName:newNamePath];

	len = [targetPath length];
	if ([travdir isEqualToString:targetPath])
		path = newNamePath;
	else {
		if (![travdir hasPrefix:targetPath])
			return NO;
		if ([travdir characterAtIndex:len] == '/')
			len++;
		path = [newNamePath stringByAppendingPathComponent:
				[travdir substringFromIndex:len]];
	}
	if (![self makeDirectories:[path stringByDeletingLastPathComponent]])
		return NO;
	return [self makeAlbumIn:travdir newName:path];
}

- (void)saveNewDoc:(id)newdoc
{
	if (isHTML)
		[newdoc saveHTMLDocAndReadyToClose:HTMLvals];
	else
		[newdoc saveDoc:self];
}

@end
