#import "TwinSliderCtrl.h"
#import "../TACommon.h"
#import "../PowerSlider.h"

@implementation TwinSliderCtrl

- (void)setValue:(int)width and:(int)height
{
	int	i;

	[(sliders[0] = widthSlider) setTag:0];
	[(sliders[1] = heightSlider) setTag:1];
	[(texts[0] = widthText) setTag:0];
	[(texts[1] = heightText) setTag:1];
	for (i = 0; i < 2; i++) {
		[sliders[i] setMaxValue:(double)MAX_THUMBNAIL];
		[sliders[i] setMinValue:(double)MIN_THUMBNAIL];
		[sliders[i] setStep:8];
	}
	[widthSlider setIntValue: width];
	[widthText setIntValue: width];
	[heightSlider setIntValue: height];
	[heightText setIntValue: height];
	[square setState: (width == height)];
}

- (void)changeSlider:(id)sender
{
	int	tag, other, val;

	tag = [sender tag];
	other = tag ? 0 : 1;
	val = [sender intValue];
	[texts[tag] setIntValue:val];
	if ([square state]) {
		double dval = [sender rawValue];
		[sliders[other] setRawValue:dval];
		[texts[other] setIntValue:val];
	}
}

- (void)changeText:(id)sender
{
	int	tag, other, val;

	tag = [sender tag];
	other = tag ? 0 : 1;
	val = [sender intValue];
	[sliders[tag] setIntValue:val];
	if ([square state]) {
		[sliders[other] setIntValue:val];
		[texts[other] setIntValue:val];
	}
}

- (NSSize)currentSize
{
	NSSize	sz;
	sz.width = [widthText intValue];
	sz.height = [heightText intValue];
	return sz;
}

@end
