#import "PowerSlider.h"
#import <math.h>

@implementation PowerSlider

- (id)init
{
	[super init];
	step = 1;
	return self;
}

- (void)setStep:(int)newstep
{
	step = newstep;
}

- (void)setDoubleValue:(double)aDouble{ [super setDoubleValue: log(aDouble)]; }
- (double)doubleValue{ return exp([super doubleValue]); }
- (void)setRawValue:(double)aDouble{ [super setDoubleValue: aDouble]; }
- (double)rawValue{ return [super doubleValue]; }
- (void)setIntValue:(int)aInt{ [super setDoubleValue: log((double)aInt)]; }
- (int)intValue{
	return (int)(exp([super doubleValue])+0.5) / step * step;
}
- (void)setMaxValue:(double)maxValue { [super setMaxValue: log(maxValue)]; }
- (void)setMinValue:(double)minValue { [super setMinValue: log(minValue)]; }
- (double)maxValue { return exp([super maxValue]); }
- (double)minValue { return exp([super minValue]); }


@end
