#import "GifSaver.h"
#import <Foundation/NSData.h>
#import <Foundation/NSString.h>
#import <AppKit/NSImage.h>
#import <stdio.h>
#import <libc.h>
#import <string.h>
#import "../TACommon.h"
#import "../imagefunc.h"
#import "../getpixel.h"
#import "ColorMap.h"
#import "gif.h"

#define  MANY_COLORS	(-1)	/* must be < 0 */

@implementation GifSaver

- init
{
	[super init];
	colormap = [[ColorMap alloc] init];
	palette = NULL;
	interlace = NO;
	return self;
}

- (void)dealloc
{
	[colormap release];
	if (palette)
		free((void *)palette);
	[super dealloc];
}

- (void)setInterlace:(BOOL)flag { interlace = flag; }

/* Local Method */
- (int)getPalette:(commonInfo *)cinf err:(int *)code
{
	int cnum;
	BOOL hasalpha = NO;

	*code = 0;
	if ([colormap allocFullColor] == nil) {
		*code = Err_MEMORY;
		return 0;
	}
	for ( ; ; ) {
		cnum = cinf->alpha
		    ? [colormap getAllColor:origmap limit:0 alpha:&hasalpha]
		    : [colormap getAllColor:origmap limit:0];
		if (hasalpha)  ++cnum;
		if (cnum < COLORSTEPS)
			break;
		[colormap shiftMask];
	}
	if (cnum > FIXcount) {
		cnum = FIXcount;
		(void)[colormap getReducedMap:&cnum alpha:hasalpha];
	}else
		(void)[colormap getNormalmap: &cnum];
	if (cnum <= 0) {
		*code = Err_MEMORY;
		return 0;
	}
	palette = [colormap getPalette];
	return cnum;
}

- saveImage:(NSImage *)image asGif:(NSString *)gifname err:(int *)err
{
	commonInfo info;
	int	cnum;
	int	transp;
	NSImage *newimage = nil;
	FILE	*fp;
	id	result = nil;

	if (!gifname || [gifname length] == 0)
		return nil;
	if ((newimage = getImageMap(image, &info, origmap)) == nil)
		return nil;
	if ((*err = initGetPixel(&info)) != 0)
		goto ErrEXIT;
	cnum = [self getPalette:&info err:err];
	if (cnum == 0)
		goto ErrEXIT;

	transp = info.alpha ? cnum : -1;
	if ((fp = fopen([gifname cString], "w")) == NULL) {
		*err = Err_SAVE;
		goto ErrEXIT;
	}
	GIFEncode(fp, &info, origmap, cnum, transp, interlace, palette);
	(void)fclose(fp);
	result = self;

ErrEXIT:
	if (newimage != image)
		[newimage release];
	return result;
}

@end
