#import "HTMLSaver.h"
#import <AppKit/NSWorkspace.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSFileManager.h>
#import <Foundation/NSBundle.h>		/* LocalizedString */
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import <libc.h>
#import "../ImageInfoNode.h"
#import "../TADocument.h"
#import "../PrefControl.h"
#import "../AlertShower.h"
#import "GifSaver.h"
#import "GifSavePanel.h"

#define  GifFILEinC	"TAhtml.gif"
#define  GifFILE	@"TAhtml.gif"
#define  GifFILEBody	@"TAhtml"

static NSFileManager *manager;

@implementation HTMLSaver

static id savePanel = nil;

/* Local Method */
- (NSString *)getSaveName:(NSString *)pathname
{
	static NSString *saveDir = nil;
	NSString *path, *fnam, *sufx;
	NSString *sav = nil;

	if (!savePanel) {
		savePanel = [GifSavePanel savePanel];
		[savePanel retain];
		[savePanel loadNib];
	}
	path = [pathname stringByDeletingLastPathComponent];
	if (path == nil || [path length] == 0)
		path = saveDir ? saveDir : @"~";
	[savePanel setTreatsFilePackagesAsDirectories: NO];
	[savePanel setRequiredFileType:@""];
	if (pathname) {
		fnam = [pathname lastPathComponent];
		if ([[fnam pathExtension] isEqualToString: Suffix])
			fnam = [fnam stringByDeletingPathExtension];
	}else
		fnam = NSLocalizedString(@"Untitled", Untitled);
	if ((sufx = [savePanel suffix]) != nil)
		fnam = [fnam stringByAppendingPathExtension: sufx];
	if ([savePanel runModalForDirectory:path file:fnam]) {
		sav = [savePanel filename];
		if (sav == nil || [sav length] == 0)
			return nil;
		if (saveDir) [saveDir release];
		saveDir = [[NSString alloc]
			initWithString:[savePanel directory]];
	}
	fnam = [sav lastPathComponent];
	if ([fnam isEqualToString:HTMLIndex] || [fnam isEqualToString:HTM_index])
		/* if "xxx/index.htm" is selected */
		sav = [sav stringByDeletingLastPathComponent];
	sufx = [savePanel suffix];
	if (sufx && ![[sav pathExtension] isEqualToString:HTMLDirSuffix])
		sav = [sav stringByAppendingPathExtension: sufx];
	HTMLvals[HTML_interlace] = [savePanel interlace];
	HTMLvals[HTML_nofilename] = [savePanel noFilename];
	HTMLvals[HTML_nosizeinfo] = [savePanel noSize];
	return sav;
}

/* Local Method */
- (void)copyHTMLGifTo:(NSString *)path
{
	static NSString *srcpath = nil;
	static NSArray *gif = nil;
	int	tag;

	if (srcpath == nil) {
		NSBundle *bundle = [NSBundle mainBundle];
		srcpath = [bundle pathForResource:GifFILEBody ofType:@"gif"];
		srcpath = [[srcpath stringByDeletingLastPathComponent] retain];
		gif = [[NSArray arrayWithObject:GifFILE] retain];
	}
	[[NSWorkspace sharedWorkspace]
		performFileOperation: NSWorkspaceCopyOperation
		source:srcpath destination:path
		files:gif tag:&tag];
}

/* Local Method */
- (id)saveImagesOfHTML:(ImageInfoNode *)a in:(NSString *)dname as:(const char *)fn
{
	int	err;
	id	saver;
	NSString *f = [a filename];
	NSImage *image = [a image];
	NSString *ifnam;

	if (f == nil || [f length] == 0 || image == nil)
		return self;
	saver = [[GifSaver alloc] init];
	[saver setInterlace: HTMLvals[HTML_interlace]];
	ifnam = [dname stringByAppendingPathComponent:
			[NSString stringWithCString:fn]];
	if ([saver saveImage:image asGif:ifnam err:&err] == nil) {
		[ErrAlert runAlert:ifnam : err];
		[saver release];
		return nil;
	}
	[saver release];
	return self;
}

/* Local Method */
- (NSString *)saveIndexOfHTML:(NSString *)dname mode:(relativ_t)relmode
{
	FILE *fp;
	NSString *xname;
	int	i, n, tr, columns;
	BOOL	suffix, gifcopied;

	xname = [dname stringByAppendingPathComponent:
		([dname hasSuffix:HTMLDirSuffixWd]) ? HTMLIndex : HTM_index];
		/* Dir "xxx.htmld" must have "index.html" <--- OmniWeb */
	if ((fp = fopen([xname cString], "w")) == NULL) {
		[ErrAlert runAlert:xname : Err_SAVE];
		return nil;
	}
	fprintf(fp, "<html>\n<body>\n<title>%s</title>\n\n",
			[[dname lastPathComponent] cString]);
	fprintf(fp, "<center>\n<table border=2>\n\n");
	fflush(fp); /* debug */

	suffix = [thePreference showSuffixOfFiles];
	gifcopied = NO;
	n = [info count];
	tr = 0;
	columns = [tadoc columns];
	for (i = 0; i < n; i++) {
		ImageInfoNode *a = [info objectAtIndex:i];
		NSString *t, *f, *b;
		char *fn, buf[16];

		if (tr == 0)
			fprintf(fp, "<tr>\n");

		f = [a filename];
		if (f == nil || [f length] == 0) {
			fprintf(fp, "<td></td>\n");
			if (++tr >= columns) {
				fprintf(fp, "</tr>\n");
				tr = 0;
			}
			continue;
		}
		fprintf(fp, "<td align=middle><a href=\"");
		t = f;
		if ([a isAbsolute]
			|| (t = [tadoc pathRelativeToAlbum:f]) == nil)
			fprintf(fp, "file:%s", [f cString]);
		else
			fprintf(fp, "../%s", [t cString]);
		fprintf(fp, "\">\n");

		b = [f lastPathComponent];
		if ([[b pathExtension] isEqualToString:HTMLDirSuffix]) {
			fn = GifFILEinC;
			if (!gifcopied) {
				[self copyHTMLGifTo:dname];
				gifcopied = YES;
			}
		}else if ([a image]) {
			sprintf(buf, "%04d.gif", i+1);
			fn = buf;
			if ([self saveImagesOfHTML:a in:dname as:fn] == nil) {
				fclose(fp);
				return nil;
			}
		}else
			fn = NULL;
		if ((t = [a titlename]) != nil)
			b = t;
		if (!suffix)
			b = [b stringByDeletingPathExtension];
		if (HTMLvals[HTML_nofilename]) {
			if (fn)
			    fprintf(fp, "<img src=\"%s\">", fn);
			else
			    fprintf(fp, "%s", [b cString]);
		}else {
			if (fn)
			    fprintf(fp, "<img src=\"%s\"><br>", fn);
			fprintf(fp, "%s", [b cString]);
		}
		fprintf(fp, "</a>");
		if (!HTMLvals[HTML_nosizeinfo])
			fprintf(fp, "<br>%s", [[a sizeString] cString]);
		fprintf(fp, "</td>\n");

		if (++tr >= columns) {
			fprintf(fp, "</tr>\n");
			tr = 0;
		}
		fflush(fp); /* debug */
	}
	if (tr > 0)
		fprintf(fp, "</tr>\n");
	fprintf(fp, "\n</table>\n</center>\n</html>\n");
	fclose(fp);
	return xname;
}

- (void)setDoc:(id)doc andInfo:(id)arr
{
	tadoc = doc;
	info = arr;
}

- (void)setHTMLattributes:(BOOL *)flags
{
	int	i;
	for (i = 0; i < HTML_BOOLS; i++)
		HTMLvals[i] = flags[i];
}

/* Local Method */
- (NSString *)saveDoc:(NSString *)newname withMode:(relativ_t)relflag
{
	NSString *xname;

	if (manager == nil)
		manager = [NSFileManager defaultManager];
	if ([manager fileExistsAtPath:newname]) { /* delete */
		if (![manager removeFileAtPath:newname handler:self]) {
			// [ErrAlert runAlert:newname : Err_SAVE];
			return nil;
		}
	}
	if (![manager createDirectoryAtPath:newname attributes:nil]) {
		[ErrAlert runAlert:newname : Err_SAVE];
		return nil;
	}
	xname = [self saveIndexOfHTML:newname mode:relflag];
	if (xname == nil)
		return nil;
	[[NSWorkspace sharedWorkspace] noteFileSystemChanged];
	return xname;
}

- (id)saveHTMLDoc:sender
{
	NSString *newname, *xname;
	relativ_t  relflag = [tadoc documentMode];  /* absolute or relative */

	newname = [tadoc filename];
	if (newname == nil || [newname length] == 0) {
		newname = [self getSaveName:[tadoc filename]];
		if (newname == nil || [newname length] == 0)
			return nil;	/* cancel */
	}else
		newname = [[newname stringByDeletingPathExtension]
				stringByAppendingPathExtension:HTMLDirSuffix];
	if (relflag != m_absolute) {
		if (![tadoc checkDirectoryPath: newname mode:&relflag])
			return nil;	/* cancel */
	}
	if ((xname = [self saveDoc:newname withMode:relflag]) == nil)
		return nil;
	return self;
}

- (id)saveHTMLDocAs:sender
{
	NSString *newname, *xname;
	NSString *openit, *edit, *ok, *mesg;
	int result;
	relativ_t  relflag = [tadoc documentMode];  /* absolute or relative */

	newname = [self getSaveName:[tadoc filename]];
	if (newname == nil || [newname length] == 0)
		return nil;	/* cancel */
	if (relflag != m_absolute) {
		if (![tadoc checkDirectoryPath: newname mode:&relflag])
			return nil;	/* cancel */
	}
	if ((xname = [self saveDoc:newname withMode:relflag]) == nil)
		return nil;
	openit = NSLocalizedString(@"Open HTML", OpenHTML);
	edit = NSLocalizedString(@"Edit it", EditHTML);
	ok = NSLocalizedString(@"OK", OK);
	mesg = NSLocalizedString(@"HTML file was made", HTMLisMade);
	result = NSRunAlertPanel(AppName, @"%@:\n%@",
			ok, openit, edit, mesg, xname);
	if (result == NSAlertAlternateReturn)
		[[NSWorkspace sharedWorkspace] openFile: xname];
	else if (result == NSAlertOtherReturn)
		[[NSWorkspace sharedWorkspace]
			openFile:xname withApplication:@"Edit.app"];
	return self;
}

@end
