#import "ResizeButton.h"
#import "PhotoCell.h"

@implementation ResizeButton

/* Over Write */
+ (Class)cellClass { return [PhotoCell class]; }
+ (void)setCellClass:(Class)classId { /* Do Nothing */ }

- (id)initWithFrame:(NSRect)frameRect
{
	[super initWithFrame:frameRect];
	infonode = [[ImageInfoNode alloc] init];
	prevnode = nil;
	[self setButtonType:NSMomentaryPushButton];
	[self setImagePosition:NSImageAbove];
	return self;
}

- (void)dealloc
{
	[infonode release];
	[super dealloc];
}

- (void)setInfo:(ImageInfoNode *)node
{
	if (node == nil) {
		[infonode setIconname: nil];
		[infonode setIconImageDirectly: nil];
		return;
	}
	if (prevnode == node)
		return;
	prevnode = node;
	[infonode setIconname: [node iconname]];
	[infonode setIconImageDirectly: [node image]];
	[self setThumbSize: [node thumbSize]];
}

- (void)setThumbSize:(NSSize)sz
{
	NSString *str;
	[infonode setThumbSize: sz];
	str = [NSString stringWithFormat:
		@"%d x %d", (int)sz.width, (int)sz.height];
	[infonode setFilename:str];
	[infonode setTitlename:str];
}

- (void)showImage
{
	[[self cell] setInfo:infonode];
	[[self cell] showIconImage];
	[self display];
}

@end
