/*
	Edge Enhancement
	Original is used in ToyViewer.
			coded by T.Ogihara
*/

#include <stdio.h>
#include <stdlib.h>
#include <objc/objc.h>
#include "../common.h"


static const char enhanceTab[5][5] = {
	{0, 1, 1, 1, 0},
	{1, 2, 3, 2, 1},
	{1, 3, 0, 3, 1},
	{1, 2, 3, 2, 1},
	{0, 1, 1, 1, 0}
};

void enhance(const commonInfo *cinf, float factor,
	const unsigned char **map, unsigned char **planes)
{
	int i, j, x, y;
	int cnum, alp;

	cnum = cinf->numcolors;
	alp = (cinf->alpha) ? (cnum + 1) : 0;

	for (y = 0; y < cinf->height; y++) {
		int curp, pw, n, v, w, totalw, totalv;
		int xlow, xhigh, ylow, yhigh;

		ylow = (y > 2) ? -2 : -y;
		if ((yhigh = cinf->height - 1 - y) > 2) yhigh = 2;
		curp = cinf->width * y;
		for (x = 0; x < cinf->width; x++, curp++) {
			if (alp) {
				planes[alp][curp] = w = map[alp][curp];
				if (w == AlphaTransp) {
					for (n = 0; n < cnum; n++)
						planes[n][curp] = 255;
					continue;
				}
			}
			xlow = (x > 2) ? -2 : -x;
			if ((xhigh = cinf->width - 1 - x) > 2) xhigh = 2;
			for (n = 0; n < cnum; n++) {
				totalv = 0;
				totalw = 0;
				for (i = ylow; i < yhigh; i++) {
				    pw = cinf->width * (y + i);
				    for (j = xlow; j < xhigh; j++) {
					totalw += w = enhanceTab[i+2][j+2];
					if (w)
					    totalv += map[n][pw+x+j] * w;
				    }
				}
				w = map[n][curp];
				v = totalv / totalw - w;
				w -= (int)(factor * v + 0.5);
				planes[n][curp] = (w < 0) ? 0
						: ((w > 255) ? 255 : w);
			}
		}
	}
}
