#import <AppKit/AppKit.h>

@interface TAController : NSObject
{
	id	printInfo;
	id	preference;
	id	sizeInspector;
}

- (void)applicationDidFinishLaunching:(NSNotification *)notification;
- (void)applicationWillTerminate:(NSNotification *)aNotification;
- (int)application:sender openFile:(NSString *)filename;
- (void)openFile:(id)sender;
- (void)reopenDocument:(id)sender;
- (void)activateSizeInspector:(id)sender;

- (void)newWindow:(id)win;
- (void)closeCurrentWindow:sender;
- (void)deleteAllWindow:sender;
- (BOOL)checkWindow:(id)win delete:(BOOL)delflag;
- (void)didBecomeMain:(id)sender;
- (id)keyWindow;
- (BOOL)isOpened:(NSString *)newfile;
- (void)print:(id)sender;
- (void)saveAs:sender;
- (void)makeNewDocument:sender;

/* Based on NSMenuActionResponder's Protocol */
- (BOOL)validateMenuItem:(NSMenuItem *)aMenuItem;

@end

extern TAController *theController;
