#import "TAController.h"
#import <AppKit/NSApplication.h>
#import <AppKit/NSPrintInfo.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSUserDefaults.h>
#import <Foundation/NSBundle.h>		/* LocalizedString */
#import <AppKit/NSPanel.h>		/* NSRunAlertPanel() */
#import <AppKit/NSMenu.h>
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import <libc.h>
#import "TACommon.h"
#import "TADocument.h"
#import "ImageInfoNode.h"
#import "PrefControl.h"
#import "AlertShower.h"
#import "SizeInspector.h"
#import "BundleLoader.h"
#import "MakeAlbum.bproj/TADocMaker.h"

/* extern */
TAController *theController = nil;

/* Local */
static id openPanel = nil;
static NSString *odir = nil;	/* Last Opened Directory */
static NSArray *fileTypeArray;

static NSMutableArray *wintab;
static id thekeywin = nil;

@implementation TAController

/* Local Method */
- (void)startSelf
{
	if (theController)
		return;
	theController = self;
	printInfo = [NSPrintInfo sharedPrintInfo];
	[printInfo setOrientation:NSLandscapeOrientation];
	[printInfo setLeftMargin: 60.0];
	[printInfo setRightMargin: 60.0];
	[printInfo setTopMargin: 60.0];
	[printInfo setBottomMargin: 60.0];

	wintab = [[NSMutableArray alloc] initWithCapacity:3];
	sizeInspector = nil;
	odir = [NSHomeDirectory() copyWithZone:[self zone]];
	openPanel = [[NSOpenPanel openPanel] retain];
	[openPanel setCanChooseDirectories:NO];
	[openPanel setAllowsMultipleSelection:NO];
        fileTypeArray = [[NSArray alloc] initWithObjects: Suffix, nil];

	[AlertShower setGlobal];
}

- (void)applicationDidFinishLaunching:(NSNotification *)notification
{
	[self startSelf];
}

- (void)applicationWillTerminate:(NSNotification *)notification
{
	int i, n, len;
	BOOL	confirm = NO;

	[thePreference synchronize];

	len = [wintab count];
	for (i = 0, n = 0; i < len && n <= 1; i++)
		if ([[wintab objectAtIndex:i] isDocumentEdited])
			n++;
	if (n == 0)
		return;	/* EXIT */
	if (n > 1) {
		NSString *quit, *conf, *mesg;
		quit = NSLocalizedString(@"Quit Anyway", QUIT);
		conf = NSLocalizedString(@"Confirm", CONFIRM);
		mesg = NSLocalizedString(@"Current document will be lost",
								DocWillLost);
		if (NSRunAlertPanel(@"", mesg, conf, quit, nil)
					== NSAlertDefaultReturn)
			confirm = YES;
	}else
		confirm = YES;
	if (confirm) {
		for (i = 0; i < len; i++)
			[[wintab objectAtIndex:i] confirmAndClose:self];
		[wintab removeAllObjects];
		thekeywin = nil;
	}
}

/* Local Method */
- (BOOL)openDocAndWindow:(NSString *)filename
{
	TADocument *doc;

	doc = [[TADocument alloc] init];
	[doc setController: self];
	if ([doc openDocument: filename] == nil) {
		[doc release];
		return NO;
	}
	[self newWindow:doc];
	return YES;
}

- (int)application:sender openFile:(NSString *)filename
{
	id	maker;

	if (printInfo == nil)
		[self startSelf];
	if (! [[filename pathExtension] isEqualToString: Suffix]) {
		maker = [[BundleLoader loadClass:b_MakeAlbum] defaultDocMaker];
		return [maker makeNewDocumentWith:filename];
	}
	if ([self isOpened: filename])
		return NO;
	return [self openDocAndWindow:filename];
}

- (void)openFile:(id)sender
{
	NSArray  *files;
	NSString *filename, *nwdir;

	if ([openPanel runModalForDirectory: odir
			file: nil types: fileTypeArray] != NSOKButton)
		return;

	files = [openPanel filenames];
	nwdir = [openPanel directory];
	if (![odir isEqualToString: nwdir]) {
		[odir release];
		odir = [nwdir retain];
	}
	filename = [files objectAtIndex: 0];
	if ([self isOpened: filename])
		return;
	[self openDocAndWindow:filename];
}

- (void)reopenDocument:(id)sender
{
	id	doc;
	NSString *filename;
	NSString *stop, *cont, *mesg;

	if ((doc = [self keyWindow]) == nil || [doc isNew]) {
		NSBeep();
		return;
	}
	stop = NSLocalizedString(@"Cancel", CANCEL);
	cont = NSLocalizedString(@"Continue", CONTINUE);
	mesg = NSLocalizedString(@"Current document will be lost", DocWillLost);
	if (NSRunAlertPanel(@"", mesg, cont, stop, nil)
		!= NSAlertDefaultReturn)
		return;	/* Do Nothing */
	filename = [doc filename];
	[filename retain];
	[doc closeAnyway:sender];
	[self openDocAndWindow:filename];
	[filename release];
}

- (void)activateSizeInspector:(id)sender
{
	if (sizeInspector == nil)
		sizeInspector = [[SizeInspector alloc] init];
	[sizeInspector activateInspector:self];
}


- (void)newWindow:(id)win
{
	[wintab addObject:win]; 
}

- (void)closeCurrentWindow:sender
{
	id cw = [self keyWindow];
	if (cw)
		[[cw window] performClose:sender];
}

- (void)deleteAllWindow:sender
{
	int i, n;

	n = [wintab count];
	for (i = 0; i < n; i++)
		[[[wintab objectAtIndex:i] window] performClose:sender];
	[wintab removeAllObjects];
	thekeywin = nil;
}

- (BOOL)checkWindow:(id)win delete:(BOOL)delflag;
{
	/* Return Value:  NO: No such window,  YES: Success */
	int	j;

	if ((j = [wintab indexOfObject:win]) == NSNotFound)
		return NO;
	if (delflag) {
		[wintab removeObjectAtIndex:j];
		if ([wintab count] == 0) {
			thekeywin = nil;
			[sizeInspector notifyCurrentDoc:self];
		}
	}
	return YES;
}

- (void)didBecomeMain:(id)sender
/* This implementation may be replaced the mechanism of Notification!! */
{
	if (thekeywin != sender) {
		thekeywin = sender;
		[sizeInspector notifyCurrentDoc:self];
	}
}

- (id)keyWindow
{
	return thekeywin;
}

- (BOOL)isOpened:(NSString *)newfile
{
	int	i, n;
	id	obj, win;

	n = [wintab count];
	for (i = 0; i < n; i++) {
		obj = [wintab objectAtIndex:i];
		if ([newfile isEqualToString:[obj filename]]) {
			win = [obj window];
			if ([win isMiniaturized])
				[win deminiaturize:self];
			[win makeKeyAndOrderFront:self];
			return YES;
		}
	}
	return NO;
}

- (void)print:(id)sender
{
	id	doc;

	if ((doc = [self keyWindow]) == nil)
		NSBeep();
	else
		[doc print:sender];
}

- (void)saveAs:sender
{
	id	doc;

	if ((doc = [self keyWindow]) == nil) {
		NSBeep();
		return;
	}
	switch ([sender tag]) {
	case 0:	[doc saveDoc:sender];
		break;
	case 1:	[doc saveDocAs:sender];
		break;
	case 2:	[doc saveHTMLDocAs:sender];
		break;
	}
}

- (void)makeNewDocument:sender
{
	id maker = [[BundleLoader loadClass:b_MakeAlbum] defaultDocMaker];
	[maker makeNewDocument:sender];
}

/* Based on NSMenuActionResponder's Protocol */
- (BOOL)validateMenuItem:(NSMenuItem *)anItem
{
	SEL	s;

	if (thekeywin)
		return YES;
	s = [anItem action];
	return (s == @selector(openFile:) 
		|| s == @selector(makeNewDocument:)
		|| s == @selector(traverseDirs:)
	);
}

@end
