#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>
#import "ImageInfoNode.h"

@class NSArray, NSFileManager, NSDictionary;

enum {	/* Paste Mode */
	P_Insert = 0,
	P_Add = 1,
	P_Empty = 2,
	P_EmptyAdd = 3
};

typedef short relativ_t;

@interface TADocument: NSObject
{
	id	window;
	NSString *docname;
	NSString *_docpath;
	id	controller;
	id	albumctr;
	id	info;	/* Array */
	short	version;
	short	columns;
	NSSize	thsize;		/* size of thumbnails */
	relativ_t  relative;	/* absolute or relative */
	short	serialNumber;	/* unique number for each document */
}

+ (int)isAlbumPath:(NSString *)path;
- (id)init;
- (void)dealloc;
- (void)setController: sender;
- window;
- (int)documentMode;
- (int)serialNumber;
- (NSSize)thumbSize;
- (NSString *)filename;
- (void)setFilename:(NSString *)name;
- (int)columns;
- (int)rows;
- (ImageInfoNode *)imageInfoAtRow:(int)row column:(int)col;
- (ImageInfoNode *)imageInfoAtSelectedCell;
- (BOOL)removeImageInfoOf:(id)rmcel;
- (BOOL)pasteImageInfo:(ImageInfoNode *)node at:(id)cel mode:(int)mode;

- (BOOL)changeWidthBy:(int)inc;
- (void)setThumbnailSize:(NSSize)size;

- (id)openDocument:(NSString *)filename;
- (void)setMode:(int)rmode columns:(int)cols size:(NSSize)size;
- (void)addImageInfoNodes:(NSArray *)fnarray in:(NSString *)dirname
	asMode:(int)mode;
- (id)openDirectory:(NSString *)dirname files:(NSArray *)fnarray;
- (BOOL)isNew;
- (BOOL)isDocumentEdited;
- (void)confirmAndClose:(id)sender;
- (void)closeAnyway:(id)sender;
- (void)releaseSelf;

- (int)levelOfSubDirectory:(NSString *)path;
- (NSString *)pathRelativeToAlbum:(NSString *)name;

/* notice from AlbumCtr */
- (void)didBecomeMain:(id)sender;

/*** Print ***/
- (void)print: sender;

@end


@interface TADocument (DocSave)

- (id)saveDocAs:sender;
- (id)saveDoc:sender;

- (BOOL)checkDirectoryPath:(NSString *)newname mode:(relativ_t *)relflag;

- (id)saveHTMLDocAs:sender;
- (id)saveHTMLDocAndReadyToClose:(BOOL *)attributes;

/* Error Handler */
- (BOOL)fileManager:(NSFileManager *)manager 
	shouldProceedAfterError:(NSDictionary *)errorDict;

@end


/* commentio.c */
void writeComment(FILE *fp, const unsigned char *comm);
unsigned char *readComment(unsigned char *comm);
