/*
	common.h	image independent information
	Original is used in ToyViewer.  This file is modified for ToyAlbum.
*/

#ifndef _COMMON_h_
#define _COMMON_h_

#include <stdio.h>

#define  ErrReturn	(-1)

#define  isAlphaOpaque(x)	((x) >= 255)
#define  isAlphaTransp(x)	((x) < 255)
#define  AlphaOpaque		255
#define  AlphaTransp		0
#define  Bright255(r, g, b)	(((r)*30 + (g)*59 + (b)*11 + 50) / 100)

#define  RED	0
#define  GREEN	1
#define  BLUE	2
#define  ALPHA	3
#define  FIXcount	256
#define  MAXPLANE	5
#define  MAXWidth	4096	/* β */

enum ns_colorspace {
	CS_White, CS_Black, CS_RGB, CS_CMYK, CS_Other
};

typedef unsigned char	paltype[3];

typedef struct {
	int	width, height;
	short	xbytes;		/* Хȿ/line */
	unsigned char	bits;
	unsigned char	numcolors;	/* color elements without alpha */
	BOOL	isplanar, alpha;
        enum ns_colorspace cspace;
} commonInfo;

#endif /* _COMMON_h_ */
