#import <Foundation/NSString.h>
#import <AppKit/NSImage.h>
#import <AppKit/NSImageRep.h>
#import <AppKit/NSEPSImageRep.h>
#import <AppKit/NSColor.h>
#import <AppKit/psopsOpenStep.h>
#import "ColorSpaceCtrl.h"
#import "common.h"

NSSize getImageSize(NSImage *image)
{
	int x;
	id rep = [image bestRepresentationForDevice:nil];
	NSSize sz = [image size];
	if ((x = [rep pixelsWide]) != NSImageRepMatchesDevice
			&& x != sz.width) {
		sz.width = x;
		sz.height = [rep pixelsHigh];
	}
	return sz;
}

NSImage *getImageMap(NSImage *origimage, commonInfo *info, unsigned char **map)
{
	id	rep;
	NSSize	sz;
	NSImage	*image, *newimage;

	image = origimage;
	rep = [image bestRepresentationForDevice:nil];
	sz = getImageSize(image);
	if (![rep isKindOfClass:[NSBitmapImageRep class]]) { /* EPS or cache */
		if ([rep isKindOfClass:[NSEPSImageRep class]]) { /* EPS */
			NSRect	r;
			NSImage	*tmpimage;
			r.size = sz;
			r.origin.x = r.origin.y = 0.0;
			tmpimage = [NSImage alloc];
			[tmpimage setSize:sz];
			[tmpimage lockFocus];
			PSsetgray(1.0); /* white */
			NSRectFill(r);
			[tmpimage unlockFocus];
			[image lockFocus];
			[tmpimage compositeToPoint:(r.origin) fromRect:r
				operation: NSCompositeDestinationOver];
			[image unlockFocus];
			[tmpimage release];
		}
		newimage = [NSImage alloc];
		[newimage initWithData:[image TIFFRepresentation]];
		if (newimage == nil)
			return nil;
		image = newimage;
		rep = [image bestRepresentationForDevice:nil];
	}

	info->width = sz.width;
	info->height = sz.height;
	info->xbytes = [rep bytesPerRow];
	info->bits = [rep bitsPerSample];
	info->numcolors = NSNumberOfColorComponents([rep colorSpaceName]);
	info->alpha = [rep hasAlpha];
	info->cspace = [ColorSpaceCtrl colorSpaceID: [rep colorSpaceName]];
	info->isplanar = [rep isPlanar];
	[rep getBitmapDataPlanes:map];

	return image;
}
