/*
 File:       ApplicationDelegate+decompression.m
 Written By: Scott Anguish
 Created:    Dec 9, 1997
 Copyright:  Copyright 1997 by Scott Anguish, all rights reserved.
*/

#import "ApplicationDelegate.h"
#import "NSFileManager+unique.h"
#import "NSString+utils.h"
#import "NSArray+utils.h"
#import "NSTask+utils.h"
#import "NSColor+utils.h"

@implementation ApplicationDelegate(decompression)


- (void)openArchive:(id)sender;
{
    int result,i, numberOfFiles;
    NSArray *theArray;
    NSOpenPanel *sharedOpenPanel = [NSOpenPanel openPanel];
    NSArray *filesToOpen;
    
    [sharedOpenPanel setAllowsMultipleSelection:YES];
    theArray=[self allSupportedFileExtensions];
    result = [sharedOpenPanel runModalForDirectory:NSHomeDirectory() file:nil types:theArray];
    if (result == NSOKButton)
      {
        filesToOpen = [sharedOpenPanel filenames];
        numberOfFiles = [filesToOpen count];
        for (i=0; i<numberOfFiles; i++)
          {
            [self decompressFile:[filesToOpen objectAtIndex:i]];
          }
      }
}


- (NSArray *)allSupportedFileExtensions;
{
    NSEnumerator *overFileTypes;
    NSDictionary *eachFileType;
    NSMutableArray *theArray=[NSMutableArray array];

    overFileTypes=[fileTypeConfigArray objectEnumerator];
    while (eachFileType = [overFileTypes nextObject])
      {
        id extensions = [eachFileType objectForKey:@"file_extension"];
        if ( [extensions isKindOfClass:[NSArray class]])
          {
            int i;
            for (i=0; i < [extensions count]; i++)
              {
                [theArray addObject:[[extensions objectAtIndex:i] substringFromIndex:1]];
              }
          }
        else
            [theArray addObject:[extensions substringFromIndex:1]];
      }
    return theArray;
}

- (NSString *)fileExtensionIn:extensions matchingString:(NSString *)theString;
{
    NSArray *fileExtensions;
    NSEnumerator *subEnumerator;
    NSString *eachFileExtension;

    // This method can except either NSArray's or NSString's in the
    // extensions variable.  The reason for this was so that if the
    // user accidently mis-configures the plist, it will still work
    // (I had alot of single string entries at one point)


    if ( [extensions isKindOfClass:[NSArray class]] )
        fileExtensions=extensions;
    else
        fileExtensions=[NSArray arrayWithObject:extensions];

    subEnumerator=[fileExtensions objectEnumerator];
    while ((eachFileExtension = [subEnumerator nextObject]))
      {
        if ([theString hasSuffix:eachFileExtension])
            return eachFileExtension;
      }
    return nil;
}


// - (NSDictionary *)matchFileToConfig:(NSString *)archivePath;
// 
// This method matches the file that we are trying to decompress to
// the appropriate dictionary which contains the decompression
// instructions

- (NSDictionary *)matchFileToConfig:(NSString *)archivePath;
{
    NSString *filename;
    NSEnumerator *overLaunchConfig;
    id eachItem;

    // isolate the filename from the path to the file
    filename=[archivePath lastPathComponent];

    //
    // grab the configuration table that we loaded during the awakeFromNib
    //
    // this object is an array of NSDictionaries with the information
    // we'll use to actually launch a task
    //
    // At first glance, it may appear that it would have been better to
    // keep these values in an NSDictionary with a key for each filetype
    // and select the individual dictionary we need using an
    // objectForKey:[filename pathExtension]
    //
    // The problem there is that we can't predict the order that the
    // keys will be searched, and that is important for our application.
    // Also file.tar.gz and file.gz both would be considered _just_ .gz
    // files by that method, which means we'd have to go through an
    // additional step to decompress the resultant .tar file.  This way
    // we can ensure that a file is checked against the longest match
    // first (.tar.gz) and if it doesn't match that, then try the shorter
    // substrings.

    overLaunchConfig=[fileTypeConfigArray objectEnumerator];
    while (eachItem = [overLaunchConfig nextObject])
      {
        // check the entire fileType key against the end of the
        // filename, if it matches then return that sub dictionary,
        // otherwise, continue testing

        if ([self fileExtensionIn:[eachItem objectForKey:@"file_extension"] matchingString:filename])
            return eachItem;
      }

    // no matches?  Return nil, the calling code will handle the situation
    return nil;
}



// - (void)decompressFile:(NSString *)archivePath;
//
// These two methods handle the decompression and compression of
// the archives
//


- (void)decompressFile:(NSString *)archivePath;
{

    NSString *shellPath;
    NSArray *shellArgs;

    NSMutableArray *launchArguments;

    NSString *unarchiveDirectoryPath;
    NSDictionary *fileConfig;
    NSString *commandBeforeSubstitution;
    NSString *commandAfterSubstitution;

    NSString *fileExtension;
    NSString *archiveFilenameWithoutPath;
    NSString *archiveFilenameWithoutFileExtension;
    NSString *archiveFilenameWithoutFileExtensionNoDots;
    NSString *archiveFilenameWithoutPathWithoutFileExtension;
    NSString *basenameForUnarchiveDirectory;
    NSString *applicationWrapperPath;
    NSString *applicationResourcesWrapperPath;
    NSMutableArray *searchValues,*replaceValues;
    NSDictionary *substitutionKeysForWrappedPrograms;
    NSDictionary *taskResults;
    NSString *decompressTargetDirectory=[self decompressTargetDirectory];


    // before anything, lets make sure that the file really does exist
    // and is readable.
    //
    // This is probably overkill, expcept that the RDR Workspace is a little slow on the update
    //
    if (![[NSFileManager defaultManager] isReadableFileAtPath:archivePath])
      {
              int result;
              result = NSRunAlertPanel(@"OpenUp",
                                       NSLocalizedString(@"DecompressionFailedFileDoesntExist",@"Unable to open archive at %@"),
                                       NSLocalizedString(@"DecompressionFailedOK",@"OK"),
                                       NULL,NULL,
                                       archivePath);
              return;
            }
    // determine the unix application to launch, and the command
    // line arguments to use based on the filename if we are unable
    // to match the filename to any of the suffixes we know how to
    // decompress then skip it..  mind you, this will only occur if
    // you've edited the config.plist in error or if you've messed
    // with the file types we support.
    // 
    // we should probably warn the user at this point..
    fileConfig=[self matchFileToConfig:archivePath];
    if (!fileConfig)
        return;

    shellPath=[self shellPathUsingConfiguration:fileConfig];
    shellArgs=[self shellArgsUsingConfiguration:fileConfig];

    fileExtension=[self fileExtensionIn:[fileConfig objectForKey:@"file_extension"] matchingString:archivePath];
    archiveFilenameWithoutPath=[archivePath lastPathComponent];
    applicationWrapperPath=[[NSBundle mainBundle] bundlePath];
    applicationResourcesWrapperPath=[[NSBundle mainBundle] resourcePath] ;
    archiveFilenameWithoutFileExtension=[archivePath stringByDeletingSuffix:fileExtension];
    archiveFilenameWithoutPathWithoutFileExtension=[archiveFilenameWithoutPath stringByDeletingSuffix:fileExtension];
    archiveFilenameWithoutFileExtensionNoDots=[archiveFilenameWithoutPathWithoutFileExtension stringByReplacing:@"." with:@"_"];
    basenameForUnarchiveDirectory=[NSString stringWithFormat:@"%@_%%@",archiveFilenameWithoutFileExtensionNoDots];

    unarchiveDirectoryPath=[[NSFileManager defaultManager] createUniqueDirectoryAtPath:decompressTargetDirectory
                                                                      withBaseFilename:basenameForUnarchiveDirectory
                                                                            attributes:nil];
    

    // If we can't create a new directory in the working directory, we
    // punt.
    if (!unarchiveDirectoryPath)
      {
        int result;
        result = NSRunAlertPanel(@"OpenUp",
                                 NSLocalizedString(@"DecompressionFailedTempDirectoryFailed",@"Unable to create temp directory %@"),
                                 NSLocalizedString(@"DecompressionFailedOK",@"OK"),
                                 NULL,NULL,
                                 decompressTargetDirectory);
        return;
      }
    else
      {
        [createdDirectories addObject:unarchiveDirectoryPath];
      }
    
    substitutionKeysForWrappedPrograms=[self wrappedProgramsUsingConfiguration:fileConfig];

    commandBeforeSubstitution = [fileConfig objectForKey:@"command"];
    searchValues=[NSMutableArray arrayWithObjects:@"%%FILE%%",
        @"%%FILENAME-WITHOUT_PATH%%",
        @"%%FILENAME-WITHOUT_FILE_EXTENSION%%",
        @"%%FILENAME-WITHOUT_FILE_EXTENSION-WITHOUT_PATH%%",
        @"%%FILE_EXTENSION%%",
        @"%%TEMPORARY_DIRECTORY%%",
        @"%%APP_BUNDLE_DIRECTORY%%",
        @"%%APP_RESOURCE_DIRECTORY%%",nil];

    [searchValues addObjectsFromArray:[substitutionKeysForWrappedPrograms objectForKey:@"keys"]];
    replaceValues=[NSMutableArray arrayWithObjects:[archivePath stringWithShellCharactersQuoted],
        [archiveFilenameWithoutPath stringWithShellCharactersQuoted],
        [archiveFilenameWithoutFileExtension stringWithShellCharactersQuoted],
        [archiveFilenameWithoutPathWithoutFileExtension stringWithShellCharactersQuoted],
        fileExtension,
        [unarchiveDirectoryPath stringWithShellCharactersQuoted],
        [applicationWrapperPath stringWithShellCharactersQuoted],
        [applicationResourcesWrapperPath stringWithShellCharactersQuoted],nil];
    [replaceValues addObjectsFromArray:[substitutionKeysForWrappedPrograms objectForKey:@"values"]];



    commandAfterSubstitution=[commandBeforeSubstitution stringByReplacingValuesInArray:searchValues
                                                                     withValuesInArray:replaceValues];
    




    launchArguments=[[shellArgs mutableCopy] autorelease];
    [launchArguments addObject:commandAfterSubstitution];

    if ([[NSUserDefaults standardUserDefaults] boolForKey:@"Debug"])
      {
        NSMutableString *debugString;
        int i;

        debugString=[NSMutableString stringWithString:@""];
        [debugString appendFormat:@"shellPath =  %@\n",shellPath];
        [debugString appendFormat:@"shellArgs = %@\n",shellArgs];
        [debugString appendFormat:@"command = %@\n",commandBeforeSubstitution];
        for (i=0; i< [searchValues count]; i++)
          {
            [debugString appendFormat:@"%@ = %@\n",[searchValues objectAtIndex:i],[replaceValues objectAtIndex:i]];
          }
        [debugString appendFormat:@"-----------------\n%@\n",launchArguments];
        [debugString appendFormat:@"Simulated command - \n"];
        [debugString appendFormat:@"%@ %@\n",shellPath,[launchArguments componentsJoinedByString:@" "]];
        if (![[NSUserDefaults standardUserDefaults] boolForKey:@"RunTask"])
            [debugString appendFormat:@"** NOTE: TASK WILL NOT BE EXECUTED ***\n"];

        [debugTextView setString:debugString];
        [debugWindow makeKeyAndOrderFront:self];

      }


    if ([fileConfig objectForKey:@"prompt_string"])
      {
        NSString *promptStringLocalizedStringKey=[NSString stringWithFormat:@"%@_prompt_string",fileExtension];
        NSString *promptTitleLocalizedStringKey=[NSString stringWithFormat:@"%@_prompt_title",fileExtension];
        NSString *promptDefaultButtonLocalizedStringKey=[NSString stringWithFormat:@"%@_prompt_default_button",fileExtension];
        NSString *promptAlternateButtonLocalizedStringKey=[NSString stringWithFormat:@"%@_prompt_alternate_button",fileExtension];
        NSString *afterSubstitutionPromptString;
        NSString *afterSubstitutionPromptTitle;
        NSString *promptString;
        NSString *promptTitle;
        NSString *promptDefaultButton;
        NSString *promptAlternateButton;
        int result;

        promptString=[[NSBundle mainBundle] localizedStringForKey:promptStringLocalizedStringKey
                                                             value:[fileConfig objectForKey:@"prompt_string"]
                                                             table:@"filesConfigComments"];

        //
        // In our quest for the ultimate localization application, I've had to really
        // take this into account here.
        //
        // if the fileConfig for this specific file type doesn't have a prompt_title,
        // prompt_default_button or prompt_alternate_button defined, we first
        // look up the default localized value in the standard Localized.strings file.
        // THIS IS NOT THE SPECIFIC TRANSLATION FOR THE FILE EXTENSION!  That comes later.
        //
        // Once we have the default prompt for the current language, we then check for
        // the localized prompt for the current language and specific fileConfig in the 
        // filesConfigComments
        // 
        if ([fileConfig objectForKey:@"prompt_title"])
            promptTitle=[fileConfig objectForKey:@"prompt_title"];
        else
            promptTitle=NSLocalizedString(@"prompt_title",@"Continue");

        promptTitle=[[NSBundle mainBundle] localizedStringForKey:promptTitleLocalizedStringKey
                                                           value:promptTitle
                                                             table:@"filesConfigComments"];

        // and again for the default button
        //
        if ([fileConfig objectForKey:@"prompt_default_button"])
            promptDefaultButton=[fileConfig objectForKey:@"prompt_default_button"];
        else
            promptDefaultButton=NSLocalizedString(@"prompt_default_button",@"Continue");
        
        promptDefaultButton=[[NSBundle mainBundle] localizedStringForKey:promptDefaultButtonLocalizedStringKey
                                                                   value:promptDefaultButton
                                                             table:@"filesConfigComments"];

        // and yet again for the alternate button
        //
        if ([fileConfig objectForKey:@"prompt_alternate_button"])
            promptAlternateButton=[fileConfig objectForKey:@"prompt_alternate_button"];
        else
            promptAlternateButton=NSLocalizedString(@"prompt_alternate_button",@"Continue");
        
        promptAlternateButton=[[NSBundle mainBundle] localizedStringForKey:promptAlternateButtonLocalizedStringKey
                                                                     value:promptAlternateButton
                                                                     table:@"filesConfigComments"];

        // We'll run the variable substitutions on the prompt and title strings, so you can specify
        // file extension or whatever in these
        //
        afterSubstitutionPromptString=[promptString stringByReplacingValuesInArray:searchValues
                                                                         withValuesInArray:replaceValues];

        afterSubstitutionPromptTitle=[promptTitle stringByReplacingValuesInArray:searchValues
                                                                         withValuesInArray:replaceValues];

        // Toss up the panel.  If they click the alternate button, we exit
        result=NSRunAlertPanel(afterSubstitutionPromptTitle,
                             afterSubstitutionPromptString,
                             promptDefaultButton,
                             promptAlternateButton,
                                NULL);
        if (result !=1)
            return;

      }


    if (![[NSUserDefaults standardUserDefaults] boolForKey:@"RunTask"])
        return;

    if ([[NSUserDefaults standardUserDefaults] boolForKey:@"ShowPanelWhileDecompresing"])
      {
        // bring out the panel
        // start any additional 'visual queues'
      }

    if ([fileConfig objectForKey:@"launch_app"])
        {
        if (![[NSWorkspace sharedWorkspace] launchApplication:[fileConfig objectForKey:@"launch_app"]])
          {
            return;
          }
        }

        taskResults=[NSTask performTask:shellPath inDirectory:unarchiveDirectoryPath withArgs:launchArguments];


    if ([[NSUserDefaults standardUserDefaults] boolForKey:@"ShowPanelWhileDecompresing"])
      {
        // Put away the panel
        // end any additional 'visual queues'
      }

    if (([(NSString *)[taskResults objectForKey:@"StandardError"] length]> 0) || ([[taskResults objectForKey:@"TerminationStatus"] intValue] != 0))
      {
	// If the termination status non zero, then we've encountered
	// an error during the decompression.  We'll do the right
	// thing and throw up a panel with the error note, as well
	// as a textview with all the details that have been returned
	// to us on stderr above.
        [errorTextField setStringValue:[NSString stringWithFormat:NSLocalizedString(@"ErrorWhileDecompressing",@"Error while decompressing %@"),archivePath]];

        [errorTextView setString:[taskResults objectForKey:@"StandardError"]];

        [errorWindow makeKeyAndOrderFront:self];
      };

    if ([[[NSFileManager defaultManager] directoryContentsAtPath:unarchiveDirectoryPath] count] > 0)
    {
	// the file is decompressed!  we'll message the workspace
	// to open the temporary directory that we've created.
	// Remember, if the directory has a file extension, even
	// accidentally, the workspace will try and open that
	// application if it exists instead of just a window
        
        if ([[NSUserDefaults standardUserDefaults] boolForKey:@"RhapsodyDirHack"])
          {
            NSMutableDictionary *hackDictionary;
            NSString *viewName;
            NSMutableString *hackFile;
            BOOL re;

            hackFile=[NSString stringWithFormat:@"%@/.dir5_0.wmd",unarchiveDirectoryPath];
            viewName=[[NSUserDefaults standardUserDefaults] stringForKey:@"RhapsodyDirViewName"];
            hackDictionary=[NSMutableDictionary dictionary];
            [hackDictionary setObject:unarchiveDirectoryPath forKey:@"RootNode"];
            [hackDictionary setObject:viewName
                               forKey:@"ViewName"];
            re=[hackDictionary writeToFile:hackFile atomically:NO];
            }
       
        [[NSWorkspace sharedWorkspace] noteFileSystemChanged];

        if ([[NSUserDefaults standardUserDefaults] boolForKey:@"SelectInWorkspaceAfterDecompress"])
          {
            [[NSWorkspace sharedWorkspace] selectFile:unarchiveDirectoryPath inFileViewerRootedAtPath:decompressTargetDirectory];
          }
      }
    if (![fileConfig objectForKey:@"launch_app"])
      {
        if ([[NSUserDefaults standardUserDefaults] boolForKey:@"PlayDecompressionSound"])
          {
            NSString *soundPath=[[NSUserDefaults standardUserDefaults] stringForKey:@"DecompressionSound"];
            NSSound *theSound;

            theSound=[[NSSound alloc] initWithContentsOfFile:soundPath byReference:NO];
            if (theSound)
              {
                [theSound setDelegate:self];
                [theSound play];
              }
          }
        if ([[NSUserDefaults standardUserDefaults] boolForKey:@"ShowPanelWhenDecompressionFinishes"])
          {
            NSRunAlertPanel(NSLocalizedString(@"DecompressionCompletePrompt",@"Completed"),
                            NSLocalizedString(@"DecompressionComplete",@"Decompression of  \"%@\" complete."),
                            NSLocalizedString(@"DecompressionCompleteOK",@"OK"),
                            NULL,
                            NULL,
                            archiveFilenameWithoutPath);
          }

      }
    return;
}


@end
