/*
 File:       ApplicationDelegate.h
 Written By: Scott Anguish
 Created:    Dec 9, 1997
 Copyright:  Copyright 1997 by Scott Anguish, all rights reserved.
*/

#import <AppKit/AppKit.h>

@interface ApplicationDelegate : NSObject
{
    NSArray *fileTypeConfigArray;
    NSDictionary *servicesDictionary;
    NSMutableArray *createdDirectories;
    BOOL initializationComplete;
    id errorWindow;
    id errorTextView;
    id errorTextField;
    id infoPanel;
    id infoPanelTextField;

    id infoPanelScrollingText;

    id debugWindow;
    id debugTextView;
    NSArray *infoPanelSupportedTypes;
    id infoTableView;

    id formatsPanel;
}

- (NSString *)decompressTargetDirectory;
- (BOOL)removeCreatedDirectoriesAllowCancel:(BOOL)allowCancel;

- (BOOL)applicationShouldTerminate:(NSApplication *)app;
- (BOOL)application:(NSApplication *)sender openFile:(NSString *)filename;
- (BOOL)application:(NSApplication *)sender openTempFile:(NSString *)filename;
- (void)initializationFailure:(NSString *)value;
- (void)awakeFromNib;
- (void)applicationDidFinishLaunching:(NSNotification *)aNotification;
- (void)setupUserDefaults;
- (void)dealloc;
- (NSString *)shellPathUsingConfiguration:(NSDictionary *)fileConfig;
- (NSArray *)shellArgsUsingConfiguration:(NSDictionary *)fileConfig;
- (NSDictionary *)wrappedProgramsUsingConfiguration:(NSDictionary *)fileConfig;

- (void)showPreferencesPanel:sender;

@end

@interface ApplicationDelegate(compression)
- (void)compressFiles:(NSPasteboard *)pboard userData:(NSString *)data error:(NSString **)error;
- (NSString *)compressFiles:(NSArray *)files withFileExtension:(NSString *)extension;
- (void)compressFiles:(NSArray *)files intoArchive:(NSString *)archivePath usingConfig:(NSDictionary *)fileConfig;
@end


@interface ApplicationDelegate(decompression)
- (void)openArchive:(id)sender;
- (NSArray *)allSupportedFileExtensions;
- (NSString *)fileExtensionIn:extensions matchingString:(NSString *)theString;
- (NSDictionary *)matchFileToConfig:(NSString *)archivePath;
- (void)decompressFile:(NSString *)archivePath;
@end


@interface ApplicationDelegate(infopanel)
- (void)setupForInfoPanel;
- (NSArray *)infoAboutSupportedFileExtensions;
- showInfoPanel:sender;
- showFormatsPanel:sender;
- mailto:sender;
- openURL:(NSString *)string;
- showFormatsPanel:sender;
- showStepwiseInOmniWeb:sender;
- showPAndLInOmniWeb:sender;
- mailSanguish:sender;
- mailPAndL:sender;

@end



