/* DFProgressPanel.h created by sanguish on Tue 03-Nov-1998 */

#import <AppKit/AppKit.h>


#define DFProgressPanelUpdateNotification @"DFProgressPanelUpdateNotification"
#define DFProgressPanelLabel @"DFProgressPanelLabel"
#define DFProgressPanelMaximum @"DFProgressPanelMaximum"
#define DFProgressPanelCurrent @"DFProgressPanelCurrent"
#define DFProgressPanelIndeterminate @"DFProgressPanelIndeterminate"



@interface DFProgressPanel : NSObject
{
    IBOutlet NSProgressIndicator *progressIndicator;
    IBOutlet NSTextField *titleField;
    IBOutlet NSPanel *window;
}
- (void)animate;
- (void)startAnimation;
- (NSWindow *)window;
- (void)setPanelTitle:(NSString *)theString;

+ (id)sharedInstance;
- (IBAction)hideWindow:(id)sender;
- (IBAction)showWindow:(id)sender;
- (void)progressPanelUpdateNofication:(NSNotification *)notification;
- (void)dealloc;

- (void)setProgressMaxValue:(double)val;
- (void)setProgressLabel:(NSString *)val;
- (void)setProgressIndeterminate:(BOOL)val;
- (void)setProgressValue:(double)val;
- (void)awakeFromNib;

@end
