/* PrefsController.h created by sanguish on Thu 24-Dec-1998 */

#import <AppKit/AppKit.h>

@interface PrefsController : NSObject
{

    IBOutlet NSTabView *preferencesTabView;

    IBOutlet NSBox *notificationsBox;
    IBOutlet NSBox *decompressionTargetBox;
    IBOutlet NSBox *expertBox;
    
    IBOutlet NSPanel *preferencesWindow;
    IBOutlet NSButton *preferencesDeleteFilesCheckbox;

    IBOutlet NSButton * showDecompressionPanelCheckbox;
    IBOutlet NSButton * selectInWorkspaceAfterDecompressionCheckbox;
    IBOutlet NSButton * playDecompressionSoundCheckbox;
    IBOutlet NSTextField *decompressionSoundField;
    IBOutlet NSTextField *setDecompressionSoundPathButton;

    IBOutlet NSButton * playCompressionSoundCheckbox;
    IBOutlet NSTextField *compressionSoundField;
    IBOutlet NSButton *setCompressionSoundPathButton;
    IBOutlet NSButton * showCompressionPanelCheckbox;
    IBOutlet NSButton * selectInWorkspaceAfterCompressionCheckbox;

    IBOutlet NSTextField *temporaryFilesDirectoryField;
    IBOutlet NSButton *defaultDeleteCheckValueCheckbox;
    
}
+ (id)sharedInstance;
- (void)showWindow;
- (void)hideWindow;

- (void)showPreferencesPanel:sender;
- (void)setTemporaryFilesDirectory:sender;
- (NSString *)showPanelForDirectoryWithInitialPath:(NSString *)thePath;
- (void)takeValueFromTemporaryFilesDirectoryField:sender;
- selectedDeleteTempFilesOnQuit:sender;
- (void)syncPreferencesPanelToCurrentSettings;
- (NSString *)showPanelForSoundWithInitialPath:(NSString *)soundFile;
- selectedCheckTempFilesOnQuit:sender;
- (void)selectedSetCompressionSoundPathButton:sender;
- (void)selectedSetDecompressionSoundPathButton:sender;
- (void)selectedShowCompressionPanelCheckbox:sender;
- (void)selectedSelectInWorkspaceAfterCompressionCheckbox:sender;
- (void)selectedShowDecompressionPanelCheckbox:sender;
- (void)selectedSelectInWorkspaceAfterDecompressionCheckbox:sender;
- (void)selectedPlayCompressionSoundCheckbox:sender;
- (void)selectedPlayDecompressionSoundCheckbox:sender;
- (void)takeValueFromCompressionField:sender;
- (void)takeValueFromDecompressionField:sender;
- (void)dealloc;
- (void)defaultsMayNeedRefreshing:(NSNotification *)notification;


@end
