/* 
 * Copyright (c) 1993-1996 NeXT Software, Inc.  All rights reserved. 
 */

#define MASTER_ADDRESS_POINTER	0x9a01
#define FIRST_BOARD_ID		0xbc
#define DEFAULT_BASE_ADDRESS	0x0388

#define AUDIO_MIXER		0x0B88
#define AUDIO_MIXER_RESET	0x17

#define MIXER_CONTROL		0x78b

typedef struct	{
    unsigned char	selectAddress			:5,
#define MIXER_A_MASTER				1  // Output Mixer
#define MIXER_B_MASTER				2  // Input Mixer
#define BASS_CONTROL				3
#define TREBLE_CONTROL				4
#define MASTER_MODE_CONTROL			5  // Loudness Filter
						   // Stereo Enhance

#define FM_SYNTHESIS				16 // FM synthesis (B)
#define INPUT_MIXER_LOOPBACK			17 // Input Mixer Loopback (A)
#define EXTERNAL_LINE_IN			18 // External Line In (B)
#define INTERNAL_LINE_IN			19 // Internal Line In (B)
#define MICROPHONE				20 // Microphone (B)
#define PCM					21 // PCM (A)
#define SPEAKER					22 // record the speaker (B)
#define SOUNDBLASTER				23 // SoundBlaster (B)
    			selectChannel			:2,
#define BOTH_CHANNELS				0
#define LEFT_CHANNEL				1
#define RIGHT_CHANNEL				2
			isTransfer			:1;
} channelSelection_t;

typedef struct {
    unsigned char	attenuation			:5,
#define MAXIMUM_ATTENUATION			0
    			routeChannel			:1,
#define MIXER_A_ROUTE				0
#define MIXER_B_ROUTE				1
			swapChannels			:2;
#define NORMAL_STEREO				0
} channelAttenuation_t;

typedef unsigned char	masterAttenuation_t;
typedef unsigned char	masterBassTrebleControl_t;

typedef struct {
    unsigned char	stereoEnhance			:2,
    			loudnessFilter			:1,
			reserved			:5;
} masterModeControl_t;

#define DEFAULT_MASTER_OUTPUT_ATTENUATION	48
#define DEFAULT_MASTER_INPUT_ATTENUATION	15
#define DEFAULT_OUTPUT_ATTENUATION		27
#define DEFAULT_INPUT_ATTENUATION		27
#define DEFAULT_MICROPHONE_ATTENUATION		30
#define MUTE					0

#define DEFAULT_BASS_BOOST			0x06	// 0 dB
#define DEFAULT_TREBLE_BOOST			0x06	// 0 dB

#define FILTER_CONTROL		0xb8a

typedef struct {
    unsigned char	filter				:5,
    			enableAudioOutput		:1,
			enableSampleRateTimer		:1,
			enableSampleBufferCounter	:1;
} filterControl_t;


#define INTERRUPT_CONTROL	0xb8b

typedef struct {
    unsigned char	enableLeftFMInterrupt		:1,
    			enableRightFMInterrupt		:1,
			enableSampleRateInterrupt	:1,
			enableSampleBufferInterrupt	:1,
			enableMIDIInterrupt		:1,
#define PAS_SIXTEEN				1
#define PAS_STUDIO				3
			version				:3;
} interruptControl_t;


#define INTERRUPT_STATUS 	0xb89

typedef struct {
    unsigned char	LeftFMInterruptPending		:1,
    			RightFMInterruptPending		:1,
			sampleRateInterruptPending	:1,
			sampleBufferInterruptPending	:1,
			MIDIInterruptPending		:1,
			channelActive			:1,
			resetActive			:1,
			sampleClippingOccurred		:1;
} interruptStatus_t;


#define CROSS_CHANNEL_CONTROL 0xf8a

typedef struct {
    unsigned char	rightToRight			:1,
    			leftToRight			:1,
			rightToLeft			:1,
			leftToLeft			:1,
			direction			:1,
#define INPUT_DIRECTION				0
#define OUTPUT_DIRECTION			1
			isMono				:1,
			enablePCM			:1,
			enableDMA			:1;
} crossChannelControl_t;

#define SAMPLE_RATE_TIMER 	0x1388
typedef unsigned short sampleRateTimer_t;
#define SAMPLE_RATE_CONSTANT 	1193180

#define SAMPLE_BUFFER_COUNTER 	0x1389
typedef unsigned short sampleBufferCounter_t;

#define SAMPLE_COUNTER_CONTROL 	0x138b

typedef struct {
    unsigned char	countFormat			:1,
#define BINARY_COUNT_FORMAT			0
    			selectMode			:3,
#define SAMPLE_BUFFER_MODE			2
#define SAMPLE_RATE_MODE			3
			latchCounter			:2,
			selectCounter			:2;
#define SAMPLE_RATE_COUNT			0
#define SAMPLE_BUFFER_COUNT			1
} sampleCounterControl_t;

#define SYSTEM_CONFIGURATION_1		0x8388

typedef struct {
    unsigned char	reserved			:1,
    			selectCompatibleClock		:1,
			reserved1			:6;
} systemConfiguration1_t;

#define SYSTEM_CONFIGURATION_2		0x8389
#define SYSTEM_CONFIGURATION_2_RESET	0x0

typedef struct {
    unsigned char	overSampling			:2,
#define OVER_SAMPLING_1X			0
#define OVER_SAMPLING_2X			1
#define OVER_SAMPLING_4X			3
    			dataEncoding			:1,
#define LINEAR_8				0
#define LINEAR_16				1
			reserved			:5;
} systemConfiguration2_t;


#define SYSTEM_CONFIGURATION_3		0x838a
#define SYSTEM_CONFIGURATION_3_RESET	0x19		// 0x18

#define SYSTEM_CONFIGURATION_4		0x838b
#define SYSTEM_CONFIGURATION_4_RESET	0x68
			
#define PRESCALE_DIVIDER		0xbf8a	
#define PRESCALE_DIVIDER_RESET		0x08

#define WAIT_STATE	  		0xbf88
#define WAIT_STATE_RESET 		0x01    


#define DMA_CHANNEL_CONFIGURATION	0xf389

typedef struct {
    unsigned char	channel				:3,
#define DMA_CHANNEL_NONE			0
#define DMA_CHANNEL_1				1
#define DMA_CHANNEL_2				2
#define DMA_CHANNEL_3				3
#define DMA_CHANNEL_0				4
#define DMA_CHANNEL_5				5
#define DMA_CHANNEL_6				6
#define DMA_CHANNEL_7				7
			reserved			:5;
} DMAChannelConfiguration_t;


#define IRQ_CONFIGURATION	 0xf38A

typedef struct {
    unsigned char	interrupt			:4,
#define INTERRUPT_NONE				0
#define INTERRUPT_2				1
#define INTERRUPT_3				2
#define INTERRUPT_4				3
#define INTERRUPT_5				4
#define INTERRUPT_6				5
#define INTERRUPT_7				6
#define INTERRUPT_10				7
#define INTERRUPT_11				8
#define INTERRUPT_12				9
#define INTERRUPT_14				10
#define INTERRUPT_15				11
			reserved			:4;
} IRQConfiguration_t;

#define COMPATIBILITY_ENABLE	0xf788

#define EMULATION_CONFIGURATION	0xfb8a

