/* Copyright (c) 1992-1996 NeXT Software, Inc.  All rights reserved. 
 *
 * QVision.h - Definition of the QVision display driver class.
 *
 * HISTORY
 * 30 Sep 92	Joe Pasqua
 *      Created. 
 * 21 May 1993	Derek B Clegg
 *	Cleaned up for external release.
 * Tue Aug 16 16:53:03 PDT 1994 James C. Lee
 *	Add 3.3 bus support & 8-bit color support.
 */
#ifndef QVISION_H__
#define QVISION_H__

#import <driverkit/IOFrameBufferDisplay.h>
#import "QVisionModes.h"


/* bus type--should eventually be moved to IOFrameBufferDisplay */
typedef enum configBusType {
	BusISAorVL,
	BusPCI,
	BusEISA
} ConfigBusType;

@interface QVision:IOFrameBufferDisplay
{
    /* The adapter; either QVisionAdapter, OrionAdapter, or Orion12Adapter. */
    QVAdapterType adapter;

    /*  Size of installed VRAM in bytes.  */
    unsigned int installedVRAMBytes;

    /* The type of DAC this device has. */
    DACtype dac;

    /* The physical address of framebuffer. */
    unsigned long videoRamAddress;

    /* The transfer tables for this mode. */
    unsigned char *redTransferTable;
    unsigned char *greenTransferTable;
    unsigned char *blueTransferTable;

    /* The number of entries in the transfer table. */
    int transferTableCount;

    /* The current screen brightness. */
    int brightnessLevel;

    /* Reserved for future expansion. */
    int _QVision_reserved[8];
    
    /* bus type reported from instance table */
    ConfigBusType	busType;
}
- (void)enterLinearMode;
- (void)revertToVGAMode;
- initFromDeviceDescription: deviceDescription;
- setBrightness:(int)level token:(int)t;
- setTransferTable:(const unsigned int *)table count:(int)count;
- free;
@end

@interface QVision (SetMode)
- determineConfiguration;
- selectMode;
- (void)initModeList;
- initializeMode;
- enableLinearFrameBuffer;
- resetVGA;
@end

@interface QVision (ProgramDAC)
- determineDACType;
- resetDAC;
- programDAC;
- setGammaTable;
@end

#endif	/* QVISION_H__ */
