/*
 * Copyright (c) 1993-1996 by NeXT Software, Inc. as an unpublished work.
 * All rights reserved.
 *
 * QVisionModes.h -- internal definitions for QVision driver.
 *
 * Author:  Derek B Clegg	21 May 1993
 *
 * Based on work by Joe Pasqua, 30 September 1992.
 */

#ifndef QVISIONMODES_H__
#define QVISIONMODES_H__

#import <objc/objc.h>
#import <driverkit/displayDefs.h>
#import "vgaModes.h"

#define QVISION_ISA_ID   	0x0E113021
#define	QVISION_EISA_ID  	0x0E113011
#define	ORION_ISA_ID     	0x0E113121
#define	ORION_EISA_ID    	0x0E113111
#define	ORION12_ISA_ID   	0x0E113122
#define	ORION12_EISA_ID  	0x0E113112

enum QVAdapterType {
    UnknownAdapter = -1,
    QVisionAdapter = 0,
    OrionAdapter = 1,
    Orion12Adapter = 2,
    QVision1280P = 3		/* PCI card */
};
typedef enum QVAdapterType QVAdapterType;

enum DACtype {
    UnknownDAC,
    Bt484,		/* BrookTree 484. */
    Bt485,		/* BrookTree 485. */
    Bt485A,		/* BrookTree 485A. */
    ATT20C505		/* AT&T 20C505 */
};
typedef enum DACtype DACtype;

/* Sizes of the various data sets. */

struct QVisionMode {
    const char *name;		/* The name of this mode. */
    QVAdapterType adapter;	/* The adapter required for this mode. */
    BOOL needsPixelDoubling;	/* YES if this mode requires pixel doubling. */

    /* Control register 1 value (63CA).  */
    unsigned char ctrlReg1;

    /* DAC command register 1 value (13C8). */
    unsigned char dacCmd1;

    /* Overflow register 1 value (3CF.42). */
    unsigned char overflow1;

    /* Overflow register 2 values (3CF.51). */
    unsigned char overflow2;

    /* Standard VGA data. */
    VGAMode vgaData;
};
typedef struct QVisionMode QVisionMode;

extern IODisplayInfo QVisionModeTable[];
extern const int QVisionModeTableCount;

#define DEFAULT_QVISION_MODE	17	/* 800 x 600 x 8 @ 60Hz. */

/* Port Addresses for Various Registers */

#define SEQ_PIXEL_WR_MSK	0x02
#define GC_PLANE_WR_MSK		0x08

/* Control Registers */
#define PAGE_REG_0		0x45	/* This is a GFXC index. */
#define PAGE_REG_1		0x46	/* This is a GFXC index. */
#define HI_ADDR_MAP		0x48	/* This is a GFXC index. */
#define ENV_REG_1		0x50	/* This is a GFXC index. */
#define VIRT_CTRLR_SEL		0x83C4
#define CTRL_REG_1		0x63CA
#define	QVGA_CTL_2		0x23C7
#define	QVGA_CTL_3		0x63CB

/* CTRL_REG_1 values */
#define PACKED_PIXEL_VIEW    	0x00
#define PLANAR_VIEW         	0x08
#define EXPAND_TO_FG         	0x10
#define EXPAND_TO_BG         	0x18
#define BITS_PER_PIX_4       	0x00
#define BITS_PER_PIX_8       	0x02
#define BITS_PER_PIX_16      	0x04
#define BITS_PER_PIX_32      	0x06

/* DAC Registers */
#define PALETTE_WRITE		0x3C8
#define PALETTE_READ		0x3C7
#define PALETTE_DATA		0x3C9
#define CO_COLOR_WRITE		0x83C8
#define CO_COLOR_DATA		0x83C9
#define DAC_CMD_0		0x83C6
#define DAC_CMD_1		0x13C8
#define DAC_CMD_2		0x13C9
#define	DAC_EXT_REG		0x13C6

/* BIOS Capability Register. */
#define BIOS_CAPABILITY_REG1	0x56
#define BIOS_CAPABILITY_REG2	0x57

/*  Use IOLog_dbg(("format", arg, ...)) to get debugging ingo when building
    the `debug' target.  Actually though, it is a whole lot easier to define
    DEBUG here so `make install' works normally.  */
#ifdef QVISION_DEBUG
#define IOLog_dbg(x) IOLog x
#else
#define IOLog_dbg(x)
#endif



#endif	/* QVISIONMODES_H__ */
