/*****************************************************************************

    SVGACustom.c for TsengLabsET4000

******************************************************************************/

#import "SVGAConstants.h"
#import <driverkit/svgaPSExtension.h>
#import <driverkit/i386/displayRegisters.h>


void SetReadSegment(unsigned char num)
// Description:	Select which 64K segment we intend to read from.
{
    char tmp;
    tmp = inb(EIDR_GCR_SEGS);
    tmp &= GCR_TS_GWR;
    tmp |= ((num << 4) & GCR_TS_GRD);
    outb(EIDR_GCR_SEGS, tmp);
}


void SetWriteSegment(unsigned char num)
// Description:	Select which 64K segment we intend to write to.
{
    char tmp;
    tmp = inb(EIDR_GCR_SEGS);
    tmp &= GCR_TS_GRD;
    tmp |= (num & GCR_TS_GWR);
    outb(EIDR_GCR_SEGS, tmp);
}


void SetReadPlane(unsigned char num)
// Description:	Select which of 4 bit planes to read from in planar
//		modes - only one plane can be active at a time.
{
    char tmp;

    //
    // Select plane we are reading from
    //
    tmp = IOReadRegister(EIDR_GCR_ADDR, GCR_AT_READ_MAPS);
    tmp &= ~GCR_AT_RMS;
    tmp |= (num & GCR_AT_RMS);
    IOWriteRegister(EIDR_GCR_ADDR, GCR_AT_READ_MAPS, tmp);
}


void SetWritePlane(unsigned char num)
// Description:	Select one of 4 bit planes to write to in planar modes.
//		Although more than one plane can be active at a time,
//		this routine only allows access to 1 plane at a time.
{
    char tmp, plane = 0x01;
    
    //
    // Convert plane num to bit enable.
    //
    plane = plane << (num & 0x03);

    //
    // Select plane we are writing to
    //
    tmp = IOReadRegister(EIDR_SEQ_ADDR, SEQ_AT_MPK);
    tmp &= ~(SEQ_AT_EM3 | SEQ_AT_EM2 | SEQ_AT_EM1 | SEQ_AT_EM0);
    tmp |= plane;
    IOWriteRegister(EIDR_SEQ_ADDR, SEQ_AT_MPK, tmp);
}


int IOSetSVGAFunctions(IOSVGAFunctions *functs)
{
    functs->setReadSegment = SetReadSegment;
    functs->setWriteSegment = SetWriteSegment;
    functs->setReadPlane = SetReadPlane;
    functs->setWritePlane = SetWritePlane;
    
    return 0;
}
