/*$Id: SenTestCase_Macros.h,v 1.2 1998/12/20 16:51:26 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#undef should(condition)
#undef shouldnt(condition)
#undef shouldBeEqual(left,right)
#undef shouldRaise(expression)

#define should(condition) \
do {  \
    if (!(condition)) {  \
        [self failWithException:[NSException failureInCondition:[NSString stringWithCString:#condition] \
                                      isTrue:NO \
                                      inFile:[NSString stringWithCString:__FILE__] \
                                      atLine:__LINE__]]; \
    }  \
} while (0)


#define shouldnt(condition) \
do {  \
    if ((condition)) {  \
        [self failWithException:[NSException failureInCondition:[NSString stringWithCString:#condition] \
                                      isTrue:YES \
                                      inFile:[NSString stringWithCString:__FILE__] \
                                      atLine:__LINE__]]; \
    }  \
} while (0)


#define shouldBeEqual(left,right)  \
do {  \
    id leftVal = (left); \
    id rightVal = (right); \
    if (![leftVal isEqual:rightVal]) { \
        [self failWithException:[NSException failureInEqualityBetween:leftVal \
                                               and:rightVal \
                                            inFile:[NSString stringWithCString:__FILE__] \
                                            atLine:__LINE__]]; \
    }  \
} while (0)


#define shouldRaise(expression)  \
do {  \
    NSException *expectedException = nil;  \
    NS_DURING  \
        (expression);  \
    NS_HANDLER  \
        expectedException = localException; \
    NS_ENDHANDLER \
    if (expectedException == nil) { \
        [self failWithException:[NSException failureInRaise:[NSString stringWithCString:#expression] \
                                  inFile:[NSString stringWithCString:__FILE__] \
                                  atLine:__LINE__]]; \
    } \
} while (0)

