/*$Id: SenTestDistributedNotifier.m,v 1.1 1998/12/20 16:51:29 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "SenTestDistributedNotifier.h"
#import "SenTestSuite.h"
#import "SenTestCase.h"
#import "SenTestSuiteRun.h"
#import "SenTestCaseRun.h"
#import <SenFoundation/SenFoundation.h>


@implementation SenTestDistributedNotifier
+ (NSString *) notificationIdentifier
{
    static NSString *notificationIdentifier = nil;
    if (notificationIdentifier == nil) {
        notificationIdentifier = [[NSUserDefaults standardUserDefaults] objectForKey:@"SenTestNotificationIdentifier"];
    }
    return notificationIdentifier;
}


- (void) postNotificationName:(NSString *) aName userInfo:(NSDictionary *) userInfo
{
    [[NSDistributedNotificationCenter defaultCenter] postNotificationName:aName
                                                                   object:[[self class] notificationIdentifier]
                                                                 userInfo:userInfo
                                                       deliverImmediately: NO];
}


+ (NSDictionary *) userInfoForObject:(id) anObject userInfo:(NSDictionary *) userInfo
{
    NSMutableDictionary *newUserInfo = [NSMutableDictionary dictionaryWithDictionary:userInfo];
    [newUserInfo setObject:[NSArchiver archivedDataWithRootObject:anObject] forKey:@"object"];
    return newUserInfo;
}


+ (void) postNotificationName:(NSString *) aNotificationName object:(id) anObject userInfo:(NSDictionary *) userInfo
{
    [[NSDistributedNotificationCenter defaultCenter] postNotificationName:aNotificationName
                                                                   object:[self notificationIdentifier]
                                                                 userInfo:[self userInfoForObject:anObject userInfo:userInfo]
                                                       deliverImmediately:NO];
}


+ (void) testSuiteDidStart:(NSNotification *) aNotification
{
    [self postNotificationName:[aNotification name] object:[aNotification object] userInfo:[aNotification userInfo]];
}


+ (void) testSuiteDidStop:(NSNotification *) aNotification
{
    [self postNotificationName:[aNotification name] object:[aNotification object] userInfo:[aNotification userInfo]];
}


+ (void) testCaseDidStart:(NSNotification *) aNotification
{
    [self postNotificationName:[aNotification name] object:[aNotification object] userInfo:[aNotification userInfo]];
}


+ (void) testCaseDidStop:(NSNotification *) aNotification
{
    [self postNotificationName:[aNotification name] object:[aNotification object] userInfo:[aNotification userInfo]];
}


+ (void) testCaseDidFail:(NSNotification *) aNotification
{
    [self postNotificationName:[aNotification name] object:[aNotification object] userInfo:[aNotification userInfo]];
}
@end
