/*$Id: SenTestLog.m,v 1.1 1998/12/20 16:51:30 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "SenTestLog.h"
#import "SenTestSuite.h"
#import "SenTestCase.h"
#import "SenTestRun.h"
#import "NSException_SenTestFailure.h"
#import <SenFoundation/SenFoundation.h>

@implementation SenTestLog
static void testlog (NSString *message)
{
    fprintf (stderr, "%s\n", [message cString]);
    fflush (NULL);
}

+ (void) testCaseDidStop:(NSNotification *) aNotification
{
    testlog ([NSString stringWithFormat:@"Test Case '%@' %s (%.3f seconds).",
        [aNotification test],
        ([[aNotification run] hasSucceeded] ? "passed" : "failed"),
        [[aNotification run] totalDuration]]);
}


+ (void) testSuiteDidStart:(NSNotification *) aNotification
{
    testlog ([NSString stringWithFormat:@"Test Suite '%@' started at %@", [aNotification test], [[aNotification run] startDate]]);
}


+ (void) testSuiteDidStop:(NSNotification *) aNotification
{
    SenTestRun *run = [aNotification run];
    SenTest *test = [aNotification test];
    testlog ([NSString stringWithFormat:@"Test Suite '%@' finished at %@.\nPassed %d test(s), with %d failure(s), %d error(s) (%.3f / %.3f seconds)",
        test,
        [run stopDate],
        [test testCaseCount],
        [run failureCount],
        [run errorCount],
        [run testDuration],
        [run totalDuration]]);
}


+ (void) testCaseDidFail:(NSNotification *) aNotification
{
    NSException *exception = [aNotification exception];
    SenTest *test = [aNotification test];
    testlog ([NSString stringWithFormat:@"%@:%@ %@ : %@",
        [exception filePathInProject],
        [exception lineNumber],
        test,
        [exception reason]]);
}
@end
