/*$Id: SenTestObserver.m,v 1.1 1998/12/20 16:51:32 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "SenTestObserver.h"
#import "SenTestSuiteRun.h"
#import "SenTestCaseRun.h"
#import <SenFoundation/SenFoundation.h>
#import <Foundation/Foundation.h>

@implementation NSNotification (SenTest)
- (SenTestRun *) run
{
    return [self object];
}


- (SenTest *) test
{
    return [[self run] test];
}


- (NSException *) exception
{
    return [[self userInfo] objectForKey:@"exception"];
}
@end


@implementation SenTestObserver
+ (void) initialize
{
    if ([self class] == [SenTestObserver class]){
        NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
        NSDictionary *registeredDefaults = [NSDictionary dictionaryWithObjectsAndKeys:
            @"SenTestLog" , @"SenTestObserverClass",
            nil];
        [defaults registerDefaults:registeredDefaults];
    }

    if ([[[NSUserDefaults standardUserDefaults] objectForKey:@"SenTestObserverClass"] isEqualToString:NSStringFromClass(self)]) {
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(testSuiteDidStart:)
                                                     name:SenTestSuiteDidStartNotification
                                                   object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(testSuiteDidStop:)
                                                     name:SenTestSuiteDidStopNotification
                                                   object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(testCaseDidStart:)
                                                     name:SenTestCaseDidStartNotification
                                                   object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(testCaseDidStop:)
                                                     name:SenTestCaseDidStopNotification
                                                   object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(testCaseDidFail:)
                                                     name:SenTestCaseDidFailNotification
                                                   object:nil];
    }
}


+ (void) testSuiteDidStart:(NSNotification *) aNotification
{   
}


+ (void) testSuiteDidStop:(NSNotification *) aNotification
{
}


+ (void) testCaseDidStart:(NSNotification *) aNotification
{
}


+ (void) testCaseDidStop:(NSNotification *) aNotification
{
}


+ (void) testCaseDidFail:(NSNotification *) aNotification
{
}
@end
