/*$Id: SenTestObserverNotifier.m,v 1.1 1998/12/20 16:51:34 marco Exp $*/
/* Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved. */

#import "SenTestObserverNotifier.h"
#import "SenTestSuite.h"
#import "SenTestCase.h"
#import <SenFoundation/SenFoundation.h>

@implementation SenTestObserverNotifier
- (id) initWithTestSuite:(SenTestSuite *) aTest
{
    self = [super initWithTestSuite:aTest];
    failureCount = 0;
    return self;
}


- (void) testSuiteDidStart:(SenTestSuite *) aTest
{
    [[NSNotificationCenter defaultCenter] postNotificationName:SenTestSuiteDidStartNotification object:aTest];
}


- (void) testSuiteDidStop:(SenTestSuite *) aTest
{
    [[NSNotificationCenter defaultCenter] postNotificationName:SenTestSuiteDidStopNotification object:aTest];
}


- (void) testCaseDidStart:(SenTestCase *) aTest
{
    [[NSNotificationCenter defaultCenter] postNotificationName:SenTestCaseDidStartNotification object:aTest];
}


- (void) testCaseDidStop:(SenTestCase *) aTest
{
    [[NSNotificationCenter defaultCenter] postNotificationName:SenTestCaseDidStopNotification object:aTest];
}


- (BOOL) hasFailures
{
    return failureCount > 0;
}


- (void) testCase:(SenTestCase *) aTest didFailWithException:(NSException *) anException
{
    failureCount++;
    [[NSNotificationCenter defaultCenter] postNotificationName:SenTestObserverExceptionNotification
                                                        object:aTest
                                                      userInfo:[NSDictionary dictionaryWithObjectsAndKeys:
                                                          anException, SenTestObserverExceptionKey , nil]];
}
@end


NSString *SenTestObserverExceptionNotification = @"SenTestObserverExceptionNotification";
NSString *SenTestObserverExceptionKey = @"exception";

