/*$Id: SenTestProbe.m,v 1.1 1998/12/20 16:51:35 marco Exp $*/

// Copyright (c) 1997, 1998, 1999, Sen:te Ltd.  All rights reserved.
//
// Use of this source code is governed by the license in OpenSourceLicense.html
// found in this distribution and at http://www.sente.ch/software/ ,  where the
// original modified of this source code can also be found.
// This notice may not be removed from this file.

#import "SenTestProbe.h"
#import "SenTestSuite.h"
#import "SenTestRun.h"

static NSAutoreleasePool *pool = nil;

@implementation SenTestProbe
+ (void) runTests:(id) ignored
{
    BOOL hasSucceeded = [[[SenTestSuite defaultTestSuite] run] hasSucceeded];
    [pool release];
    exit (hasSucceeded ? 0 : 1);
}


+ (void) load
{
    if ([[NSUserDefaults standardUserDefaults] boolForKey:@"SelfTest"]) {
        pool = [[NSAutoreleasePool alloc] init];
        [self performSelector:@selector(runTests:) withObject:nil afterDelay:0.0];
    }
}
@end
