#import "GammaInterface.h"


// Convert from and to the gamma values for the non-linear slider.
static double sliderToGamma(double s)
{
	return pow(4.0, s);
}

static double gammaToSlider(double g)
{
	return log(g) / log(4.0);
}


@implementation GammaInterface

// Register for textDidChange notifications.
- initWithEngineData: (ActionData *)data
{
	self = [super initWithEngineData: data];
	if(self)
	{
		[[NSNotificationCenter defaultCenter]
			addObserver: self
			selector: @selector(textDidChange:)
			name: NSControlTextDidChangeNotification
			object: gammaField];
	}

	return self;
}

// Cleanup.
- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver: self];

	[super dealloc];
}


// Write the default parameters to the ActionData object.
+ (void)modifyDataToReflectDefaults: (ActionData *)data
{
	[super modifyDataToReflectDefaults: data];

	[data setDouble: 1.8  forKey: @"Gamma"];
}

// Save the parameters from the UI to the ActionData object.
- (void)modifyDataToReflectSettings: (ActionData *)data
{
	double	gamma;

	[super modifyDataToReflectSettings: data];

	gamma = [gammaField doubleValue];
	[data setDouble: gamma  forKey: @"Gamma"];
}

// Update the UI to reflect the ActionData's parameters.
- (void)updateToReflectEngineData: (ActionData *)data
{
	double	gamma;

	[super updateToReflectEngineData: data];

	gamma = [data doubleForKey: @"Gamma"];
	[gammaSlider setDoubleValue: gammaToSlider(gamma)];
	[gammaField setStringValue: [NSString stringWithFormat: @"%.2f", gamma]];
}


// The slider has moved, update the TextField.
- (void)sliderChanged: sender
{
	double	gamma;

	gamma	= sliderToGamma([gammaSlider doubleValue]);
	[gammaField setStringValue: [NSString stringWithFormat: @"%.2f", gamma]];
}

// The user typed something: Update the slider.
- (void)textDidChange: (NSNotification *)notification
{
	double	gamma;

	gamma	= [gammaField doubleValue];
	[gammaSlider setDoubleValue: gammaToSlider(gamma)];
}

@end
