#import "Action.h"

#ifdef CS_INTERNAL
#import <CSFoundation/CSFoundation.h>
#else
#import "CSMeasurementUnit.h"
#endif


// The 'XxxxAction' classes contain the actual filter implementation.

@interface MosaicAction: Action
{
	CSMeasurementUnit	*size;		
	void				*buffer;

	int				 side;
	int				 width,height;

	int				 oldU, oldV, oldW;
}

- initWithEngineData: (ActionData *)data;
- (void)dealloc;

- (void)preLaunchMainThread;
- (void)preLaunchExecThread;
- (void)postEndExecThread;
- (void)postEndMainThread;

- (void)getRGBAPixel: (RGBAPixel *)p  at: (int)x: (int)y  count: (int)n;
- (void)getCMYKAPixel: (CMYKAPixel *)p  at: (int)x: (int)y  count: (int)n;

@end
