/* DocumentWriter.h created by stanj on Sun 17-May-1998 */

#import <AppKit/AppKit.h>

#import "Document.h"


#define	OutputFormatDescriptions		@"OutputFormatDescriptions"
#define	LocalOutputFormatDescriptions	@"LocalOutputFormatDescriptions"
#define	OutputFormatDescription		@"OutputFormatDescription"
#define	OutputFileName				@"OutputFileName"
#define	OutputFileDynamicSettings		@"OutputFileDynamicSettings"
#define	OutputFileDirectory			@"OutputFileDirectory"
#define	OutputFileExtension			@"OutputFileExtension"
#define	ErrorFailsSilently			@"ErrorFailsSilently"
#define	ActiveLayerIndices			@"ActiveLayerIndices"
#define	VisibleLayerIndices			@"VisibleLayerIndices"
#define	ActiveMarqueeIndices		@"ActiveMarqueeIndices"
#define	VisibleMarqueeIndices		@"VisibleMarqueeIndices"


@protocol DocumentWriter <NSObject>

- init;
- (void)dealloc;

- (BOOL)writeDocument:(id <Document>)doc parameters:(NSDictionary *)params;

- (double)progress;
- (void)abort;

- (BOOL)isMultithreaded;
- (BOOL)isAbortable;
- (BOOL)hasProgress;

@end



// ABSTRACT SUPERCLASS for output writers
// all it does is taking care of setting the "shouldAbort" flag

@class Document;

@interface DocumentWriter : NSObject <DocumentWriter>
{
	BOOL			shouldAbort;
}

@end
