
#import "PixelSource.h"
#import "DocumentProtocol.h"

@class CSAffineTransform;


@protocol Layer <NSObject>

- (CSAffineTransform *)transform;
- (void)setTransform: (CSAffineTransform *)transform;

// returns the bitmap
- (id <PixelSource>) bitmap;		
- (void) assignNewBitmap:(id <PixelSource>)b;

- (id <Document>) document;

// YES if possibly (semi)transparent
- (BOOL) isTransparent;		


// setting / getting DPI value
- (void) setDpi:(double)d;	
- (double) dpi;

// setting/getting compression
- (void) setQFactor:(float)qf;	
- (float) qFactor;

- (void) setCompression:(NSTIFFCompression)c;
- (NSTIFFCompression) compression;

// querying anchor (usually centerpoint) and bounding box
- (NSPoint) anchor;
- (NSRect) boundingBox;

- (NSString *) name;

@end
