
#ifdef CS_INTERNAL
#import <CSImaging/CSImaging.h>
#else
#import "CSMeasurementUnit.h"
#endif


typedef enum
{
	WRAP_TRANSPARENT,
	WRAP_CLAMP,
	WRAP_CYCLIC
} WrapMode;


@protocol PixelSource <NSObject>

- (void)getRGBAPixel: (RGBAPixel *)p  at: (int)x: (int)y  count: (int)n;
- (void)getCMYKAPixel: (CMYKAPixel *)p  at: (int)x: (int)y  count: (int)n;

- (double)dpi;

- (int)width;
- (int)height;

- (BOOL)isCMYKA;

@end


@protocol PixelDestination <PixelSource>

- (void)putRGBAPixel: (RGBAPixel *)p  at: (int)x: (int)y  count: (int)n;
- (void)putCMYKAPixel: (CMYKAPixel *)p  at: (int)x: (int)y  count: (int)n;

@end


@protocol TBitmap <PixelDestination>

- (void) getBitmapDataPlanes:(uchar **)planes;
- (int) bytesPerRow;

@end
