/*
 * Copyright (c) 1991 NeXT Computer, Inc.  All rights reserved.
 *
 *	File:	mach/ppc/thread_status.h
 *	Author:	Mike DeMoney, NeXT Computer, Inc.
 *
 *	This include file defines the per-thread state
 *	for Apple ppc-based products.
 *
 * HISTORY
 *  1-Apr-97   Umesh Vaishampayan (umeshv@NeXT.com)
 *  Replaced the contents to be in sync with the kernel.
 *  Condensed the OSF change history.
 *
 *  31-Jan-97  Kevin Enderby (enderby@next.com)
 *	Changed m98k to ppc.
 *
 *  5-Nov-92  Ben Fathi (benf@next.com)
 *	Ported to m98k.
 *
 * 23-Jan-91  Mike DeMoney (mike@next.com)
 *	Created.
 */

/*
 * @OSF_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: thread_status.h,v $
 * Revision 1.1.1.1  1997/09/03 20:53:39  roland
 * Initial checkin of SGS release 244
 *
 * 
 * Revision 1.1.2.1  1995/08/25  06:49:56  stephen
 * 	Initial checkin of files for PowerPC port
 * 	[1995/08/23  15:04:50  stephen]
 * 
 * $EndLog$
 */

#ifndef	_MACH_PPC_THREAD_STATUS_H_
#define _MACH_PPC_THREAD_STATUS_H_

#import <architecture/ppc/basic_regs.h>

/*
 * ppc_thread_state is the structure that is exported to user threads for 
 * use in status/mutate calls.  This structure should never change.
 *
 * TODO : it'd be nice to provide 64 bit compatibility in this structure
 *        - need to make sure that it's understood by gdb though?
 */

#define PPC_THREAD_STATE	1
#define PPC_FLOAT_STATE		2
#define PPC_EXCEPTION_STATE	3
#define THREAD_STATE_NONE	7
	       
typedef struct ppc_thread_state {
	unsigned int srr0;	/* Instruction address register (PC) */
	msr_t srr1;			/* Machine state register (supervisor) */
						/* srr1 may contain SRR_SYSCALL_VAL */
	unsigned int r0;
	unsigned int r1;	/* stack pointer */
	unsigned int r2;
	unsigned int r3;
	unsigned int r4;
	unsigned int r5;
	unsigned int r6;
	unsigned int r7;
	unsigned int r8;
	unsigned int r9;
	unsigned int r10;
	unsigned int r11;
	unsigned int r12;
	unsigned int r13;
	unsigned int r14;
	unsigned int r15;
	unsigned int r16;
	unsigned int r17;
	unsigned int r18;
	unsigned int r19;
	unsigned int r20;
	unsigned int r21;
	unsigned int r22;
	unsigned int r23;
	unsigned int r24;
	unsigned int r25;
	unsigned int r26;
	unsigned int r27;
	unsigned int r28;
	unsigned int r29;
	unsigned int r30;
	unsigned int r31;

	cr_t cr;			/* Condition register */
	xer_t xer;			/* User's integer exception register */
	unsigned int lr;	/* Link register */
	unsigned int ctr;	/* Count register */
	unsigned int mq;	/* MQ register (601 only) */

	unsigned int pad;	/* structure TODO - check these! */
} ppc_thread_state_t;

#define PPC_THREAD_STATE_COUNT \
   (sizeof(struct ppc_thread_state) / sizeof(int))


/* This structure should be double-word aligned for performance */

typedef struct ppc_float_state {
	double  fpregs[32];

	unsigned int fpscr_pad;	/* fpscr is 64 bits, 32 bits of rubbish */
	unsigned int fpscr;		/* floating point status register */
} ppc_float_state_t;

#define PPC_FLOAT_STATE_COUNT \
   (sizeof(struct ppc_float_state) / sizeof(int))


/*
 * saved state structure
 *
 * This structure corresponds to the state of the user registers as saved
 * on the stack upon kernel entry (saved in pcb). On interrupts and exceptions
 * we save all registers. On system calls we only save the registers not
 * saved by the caller.
 *
 * NB: If you change this structure you must also change the KGDB stub as well.
 * 
 * TODO : not sure about the save/restore regs. Does this need to be
 *        different to ppc_thread_state?
 */

typedef struct ppc_saved_state {
	unsigned int srr0;	/* Instruction address register (PC) */
	msr_t srr1;			/* Machine state register (supervisor) */
						/* srr1 may contain SRR_SYSCALL_VAL */
	unsigned int r0;
	unsigned int r1;
	unsigned int r2;	/* stack pointer */
	unsigned int r3;
	unsigned int r4;
	unsigned int r5;
	unsigned int r6;
	unsigned int r7;
	unsigned int r8;
	unsigned int r9;
	unsigned int r10;
	unsigned int r11;
	unsigned int r12;
	unsigned int r13;
	unsigned int r14;
	unsigned int r15;
	unsigned int r16;
	unsigned int r17;
	unsigned int r18;
	unsigned int r19;
	unsigned int r20;
	unsigned int r21;
	unsigned int r22;
	unsigned int r23;
	unsigned int r24;
	unsigned int r25;
	unsigned int r26;
	unsigned int r27;
	unsigned int r28;
	unsigned int r29;
	unsigned int r30;
	unsigned int r31;

	cr_t cr;			/* Condition register */
	xer_t xer;			/* User's integer exception register */
	unsigned int lr;	/* Link register */
	unsigned int ctr;	/* Count register */
	unsigned int mq;	/* MQ register (601 only) */
	unsigned int pad;	/* To mirror pcb_thread_state in pcb*/

	unsigned int sr_copyin; /* SR_COPYIN is used for remapping */
	unsigned int pad2;		/* struct alignment */
	unsigned int pad3;
	unsigned int pad4;
} ppc_saved_state_t;

/*
 * ppc_exception_state
 *
 * This structure corresponds to some additional state of the user
 * registers as saved in the PCB upon kernel entry. They are only
 * available if an exception is passed out of the kernel, and even
 * then not all are guaranteed to be updated.
 *
 * Some padding is included in this structure which allows space for
 * servers to store temporary values if need be, to maintain binary
 * compatiblity.
 */

typedef struct ppc_exception_state {
	unsigned long dar;	/* Fault registers for coredump */
	unsigned long dsisr;
	unsigned long exception;/* number of powerpc exception taken */
	unsigned long pad0;	/* align to 16 bytes */

	unsigned long pad1[4];	/* space in PCB "just in case" */
} ppc_exception_state_t;

#define PPC_EXCEPTION_STATE_COUNT \
   (sizeof(struct ppc_exception_state) / sizeof(int))


/*
 * Machine-independent way for servers and Mach's exception mechanism to
 * choose the most efficient state flavor for exception RPC's:
 */
#define MACHINE_THREAD_STATE		PPC_THREAD_STATE
#define MACHINE_THREAD_STATE_COUNT	PPC_THREAD_STATE_COUNT

/*
 * Largest state on this machine:
 */
#define THREAD_MACHINE_STATE_MAX	PPC_THREAD_STATE_COUNT


#define	PPC_THREAD_STATE_FLAVOR_COUNT  3

#define PPC_THREAD_STATE_FLAVOR_LIST_COUNT         \
	( PPC_THREAD_STATE_FLAVOR_COUNT *              \
		(sizeof (struct thread_state_flavor) / sizeof(int)))

#endif /* _MACH_PPC_THREAD_STATUS_H_ */
