/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/

#import <Foundation/NSObject.h>

@class NSWindow;
@class NSMenu;
@class MainWindow;
@class MainView;
@class EqView;
@class PlaylistView;
@class NSTimer;

@interface AppDelegate : NSObject
{
  MainWindow *mainWindow, *eqWindow, *playlistWindow;
  id eqMenu, miscOptsMenu, sortMenu, fileMenu;
  id preferences, skinBrowser;
  BOOL initialized;
  NSString *startupPlayFile;
  NSTimer *visTimer;
  id aboutText;
  id aboutPanel;
}

- (NSWindow *)mainWindow;
- (NSWindow *)eqWindow;
- (NSWindow *)playlistWindow;
- (MainView *)mainView;
- (EqView *)eqView;
- (PlaylistView *)playlistView;

- (NSMenu *)eqMenu;
- (NSMenu *)miscOptsMenu;
- (NSMenu *)sortMenu;
- (NSMenu *)fileMenu;

- (BOOL)savePlaylist;

- (void)lockMainInfoText:(NSString *)string;
- (void)unlockMainInfoText;

- (void)addAndPlayFile:(NSString *)file;

- (void)resetVisTimer;

- (void)hideShowPlaylist:sender;
- (void)hideShowEq:sender;
- (void)hideShowMain:sender;

- (void)openFilePanel:sender;
- (void)time_elapsed:sender;
- (void)time_remaining:sender;
- (void)vis_type:sender;
- (void)analyzer_mode:sender;
- (void)analyzer_type:sender;
- (void)analyzer_peaks:sender;
- (void)scope_mode:sender;
- (void)vu_mode:sender;
- (void)refresh_rate:sender;
- (void)analyzer_falloff:sender;
- (void)peaks_falloff:sender;
- (void)about:sender;
- (void)eject_pressed:sender;
- (void)play_pressed:sender;
- (void)stop_pressed:sender;
- (void)pause_pressed:sender;
- (void)fwd_pressed:sender;
- (void)prev_pressed:sender;
- (void)shuffle_pressed:sender;
- (void)repeat_pressed:sender;
- (void)toggle_repeat:sender;
- (void)toggle_shuffle:sender;
- (void)toggle_noplaylist_advance:sender;
- (void)showFileInfoBox:sender;

@end
