/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/
#import "MainWindow.h"
#import "Config.h"
#import "Skin.h"
#import "Preferences.h"
#import "Plugins.h"
#import "PlaylistEntry.h"
#import "AppDelegate.h"

@implementation MainWindow

- (id)initWithContentRect:(NSRect)contentRect 
		styleMask:(unsigned int)aStyle 
		  backing:(NSBackingStoreType)bufferingType 
		    defer:(BOOL)flag
		     name:(NSString *)_name
{
  [super initWithContentRect:contentRect 
		   styleMask:aStyle 
		     backing:bufferingType 
		       defer:flag];
  [self setAcceptsMouseMovedEvents:YES];

  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(keyWindow:)
	   name:NSWindowDidBecomeKeyNotification
	 object:self];
  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(keyWindow:)
	   name:NSWindowDidResignKeyNotification
	 object:self];
  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(windowDidMove:)
	   name:NSWindowDidMoveNotification
	 object:self];
  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(thingsChanged:)
	   name:SkinChangedNotification
	 object:nil];
  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(thingsChanged:)
	   name:PreferencesChangedNotification
	 object:nil];
  name = [_name retain];

  [self setFrameUsingName:name];
  [self updateAlwaysOnTop];

  [self registerForDraggedTypes:
       [NSArray arrayWithObject:NSFilenamesPboardType]];

  return self;
}


- (unsigned int)draggingUpdated:(id <NSDraggingInfo>)sender
{
  return NSDragOperationCopy;
}

- (unsigned int)draggingEntered:(id <NSDraggingInfo>)sender
{
  return [self draggingUpdated:sender];
}


- (BOOL)prepareForDragOperation:(id <NSDraggingInfo>)sender
{
  return YES;
}

- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender
{
  NSPasteboard *pb = [sender draggingPasteboard];
  NSArray *files;
  
  files = [pb propertyListForType:NSFilenamesPboardType];

  if ( [files count] ) {
    [Playlist addFiles:files];
    [Input playFile:[files objectAtIndex:0]];
  }
  return YES;
}

- (void)windowDidExpose:(NSNotification *)notification
{
  [self makeFirstResponder:[self contentView]];
}

- (void)windowDidMove:(NSNotification *)notification
{
  [self saveFrameUsingName:name];
}

- (void)keyWindow:notification
{
  [[self contentView] setNeedsDisplay:YES];
}

- (BOOL)canBecomeKeyWindow
{
  return YES;
}

- (void)updateAlwaysOnTop
{
  if ( [cfg always_on_top] && [self level] != 1 )
    [self setLevel:1];
  else if ( [cfg always_on_top] == NO && [self level] != NSNormalWindowLevel)
    [self setLevel:NSNormalWindowLevel];
}

- (void)thingsChanged:(NSNotification *)notification
{
  [self updateAlwaysOnTop];
  [self display];
}

@end
