/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/
#import "NormPlaylistList.h"
#import "PlaylistEntry.h"
#import "Skin.h"
#import "Config.h"

@implementation NormPlaylistList

- (void)entryInfoUpdaterThread:nothing
{
  int i, start = [nothing intValue];
  NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
  [infoUpdaterLock lock];
  for ( i = start; i < start+num_visible && infoUpdateStopRequested == NO; i++ ) {
    if ( i < [Playlist count] ) {
      [[Playlist entryAtIndex:i] loadInfo];
      [self setNeedsDisplay:YES];
    }
  }
  [infoUpdaterLock unlock];
  [pool release];
}

- initWithFrame:(NSRect)frame target:_target action:(SEL)_action 
					     slider:_slider
{
  [super initWithFrame:frame];
  last_selection = -1;
  target = _target;
  action = _action;
  infoUpdaterLock = [[NSLock alloc] init];
  slider = _slider;
  first = -1;

  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(selectionChanged:)
	   name:PlaylistSelectionChangedNotification
	 object:nil];
  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(playlistChanged:)
	   name:PlaylistChangedNotification
	 object:nil];
  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(newPlaylist:)
	   name:NewPlaylistNotification
	 object:nil];

  return self;
}

- (void)mouseUp:(NSEvent *)theEvent
{
}


#define startTimer() \
  if ( doingPeriodicEvents == NO ) { \
    [NSEvent startPeriodicEventsAfterDelay:0.1 withPeriod:0.1]; \
    doingPeriodicEvents = YES; \
    autoScrollEvent = [theEvent retain]; \
  }

#define stopTimer() \
  [NSEvent stopPeriodicEvents]; \
  doingPeriodicEvents = NO; \
  [autoScrollEvent release]; \
  autoScrollEvent = nil;


- (void)mouseDown:(NSEvent *)theEvent
{
  NSPoint point;
  int idx;
  PlaylistEntry *entry;
  int i;

  if ( [Playlist count]  == 0 )
    return;

  point = [self convertPoint:[theEvent locationInWindow] fromView:nil];

  idx = first + (num_visible - (point.y / fheight));
  entry = [Playlist entryAtIndex:idx];
  
  if ( [theEvent modifierFlags] & NSCommandKeyMask ) {
    [entry setSelected:![entry selected]];
  } else if ( [theEvent modifierFlags] & NSShiftKeyMask ) {
    if ( last_selection == -1 ) {
      [entry setSelected:YES];
    } else {
      int start, stop;
      start = idx > last_selection ? last_selection : idx;
      stop = idx > last_selection ? idx : last_selection;
      for ( i = start; i <= stop; i++ )
	[[Playlist entryAtIndex:i] setSelected:YES];
    }
  } else if ( [theEvent modifierFlags] & NSControlKeyMask ) {
    NSPoint curPoint;
    int moveCurTo = idx, minSel, maxSel;
    int moveTo;
    BOOL doingPeriodicEvents = NO;
    NSRect frame = [self frame];
    NSEvent *autoScrollEvent = nil;
    
    if ( [entry selected] ) {
      while (1) {

	theEvent = [[self window] nextEventMatchingMask:
		     (NSLeftMouseDraggedMask | NSLeftMouseUpMask
		      | NSPeriodicMask)];

	if ([theEvent type] == NSLeftMouseUp)
	  break;

	curPoint = [theEvent locationInWindow];
	curPoint = [self convertPoint:curPoint fromView:nil];

	if ( [theEvent type] == NSPeriodic  ) {
	  curPoint = [self convertPoint:[autoScrollEvent locationInWindow]
			       fromView:nil];
	}
	
	if ( curPoint.y < 0 ) {
	  moveCurTo++;
	  first = moveCurTo-num_visible+1;
	  if ( first < 0 )
	    first = 0;
	  startTimer();
	} else if ( curPoint.y > frame.size.height ) {
	  moveCurTo--;
	  first = moveCurTo;
	  startTimer();
	} else {
	  moveCurTo = first + (num_visible - (curPoint.y /fheight));
	  stopTimer();
	}

	minSel = [Playlist minSelectedIndex];
	maxSel = [Playlist maxSelectedIndex];
	moveTo = moveCurTo - (idx - minSel);

	if ( moveTo < 0 ) {
	  moveCurTo = idx;
	  continue;
	} else if ( moveTo + (maxSel-minSel) >= [Playlist count] ) {
	  moveCurTo = idx;
	  continue;
	}

	[Playlist moveSelectionToIndex:moveTo];
	idx = moveCurTo;
      }
      if ( doingPeriodicEvents )
	stopTimer();
    }
  } else {
    NSArray *cur = [Playlist selectedItems];
    for ( i = 0; i < [cur count]; i++ )
      [[cur objectAtIndex:i] setSelected:NO];
    [entry setSelected:YES];

    if ( [theEvent clickCount] > 1 )
      [target performSelector:action withObject:self];
  }
  last_selection = idx;
  
  [Playlist selectionChanged];
}

- (int)selected
{
  return last_selection;
}

- (void)scrollUp
{
  if ( first > 0 ) {
    [self scrollTo:first-1];
  }
}

- (void)scrollDown
{
  if ( first + num_visible + 1 < [Playlist count] ) {
    [self scrollTo:first+1];
  }
}

- (void)scrollTo:(int)pos
{
  first = pos;
  if ( [infoUpdaterLock tryLock] == NO ) {
    infoUpdateStopRequested = YES;
    [infoUpdaterLock lock];
    [infoUpdaterLock unlock];
  } else
    [infoUpdaterLock unlock];
  infoUpdateStopRequested = NO;
  [slider setIntValue:[slider maxValue] - pos];
  [NSThread detachNewThreadSelector:@selector(entryInfoUpdaterThread:)
			   toTarget:self
			 withObject:[NSNumber numberWithInt:first]];
  [self setNeedsDisplay:YES];
}

- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent
{
  return YES;
}

- (BOOL)becomeFirstResponder
{
  return YES;
}

- (BOOL)resignFirstResponder
{
  return YES;
}

- (BOOL)acceptsFirstResponder
{
  return YES;
}

- (void)centerCurrentIfNeeded
{
  [self centerCurrent:NO];
}

- (void)centerCurrent:(BOOL)force
{
  int pos = [cfg playlist_position];
  if ( force == YES || pos < first || pos > (first+num_visible-1) ) {
    first = [cfg playlist_position] - (num_visible/2);
    if ( first < 0 )
      first = 0;
    [self scrollTo:first];
  }
}

- (void)drawRect:(NSRect)rect
{
  NSFont *font=NULL;
  int width,height;
  PlaylistEntry *entry;
  NSString *text,*title, *length;
  int i,tw,max_first, ofirst;

  width = [self frame].size.width;
  height = [self frame].size.height;
	
  [[currentSkin pledit_normalbg] set];
  NSRectFill(rect);

  font = [cfg playlist_font];
  [font set];
  
  fheight = [font boundingRectForFont].size.height + 1;
  num_visible = height / fheight;

  if ( first == -1 )
    [self centerCurrent:YES];
  
  ofirst = first;
  max_first=([Playlist count] - num_visible);
  if ( max_first < 0 )
    max_first = 0;
  if ( first >= max_first )
    first = max_first;
  if ( first < 0 ) 
    first=0;
  if ( first != ofirst )
    [self scrollTo:first];

  for ( i = first; i < [Playlist count] && i < first+num_visible; i++ ) {   
    entry = [Playlist entryAtIndex:i];
    if ( [entry selected] ) {
      [[currentSkin pledit_selectedbg] set];
      NSRectFill(NSMakeRect(0, height-((i-first)*fheight)-fheight-3,width,fheight));
    }
    if(i == [cfg playlist_position])
      [[currentSkin pledit_current] set];
    else
      [[currentSkin pledit_normal] set];

    title = [entry title];
    if( title == nil ) {
      title = [[entry filename] lastPathComponent];
    }
			
    if([entry length] != -1) {
      length = [NSString stringWithFormat:@"%d:%-2.2d",[entry length]/60000,
		 ([entry length]/1000)%60];

      tw = [font widthOfString:length];
      PSmoveto(width-tw-2, height -((i-first)*fheight)-fheight);
      PSshow([length cString]);
      tw = width - tw - 5;
    } else {
      tw=width;
    }
    if([cfg show_numbers_in_pl])
      text = [NSMutableString stringWithFormat:@"%d. %@", i+1, title];
    else
      text = [NSMutableString stringWithString:title];

#if 0
    if(cfg.convert_underscore)
      while(tmp=strchr(text,'_'))
	*tmp=' ';
    if(cfg.convert_twenty)
      while(tmp=strstr(text,"%20")) {
	tmp2=tmp+3;
	*(tmp++)=' ';
	while(*tmp2)
	  *(tmp++)=*(tmp2++);
	*tmp='\0';
      }
    len=strlen(text);
    while((font,text,len)>tw&&len>4) 
      {
	len--;
	text[len-3]='.';
	text[len-2]='.';
	text[len-1]='.';
	text[len]='\0';
      }
#endif

    while ( ([font widthOfString:text] > tw) && [text length] )
      text = [text substringToIndex:[text length]-1];

    PSmoveto(0, height-((i-first) * fheight)-fheight);
    PSshow([text cString]);
  }
}

- (void)newPlaylist:(NSNotification *)notification
{
  first = -1;
  [self setNeedsDisplay:YES];
}

- (void)playlistChanged:(NSNotification *)notification
{
  [self setNeedsDisplay:YES];
}

- (void)selectionChanged:(NSNotification *)notification
{
  [self setNeedsDisplay:YES];

}
@end

