/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import  <SoundKit/SoundKit.h>
#import "SoundKit.h"
#import "SoundStream.h"

@implementation SoundKit

- (int)writtenTime
{
  return [playingStream getWrittenTime];
}

- (int)outputTime
{
  return [playingStream getOutputTime];
}

- (int)used
{
  return 0;
}

- (BOOL)playing
{
  return [playingStream isActive];
}

- (int)bufferFree
{
  return [playingStream getFree];
//  return 10000000;
}

- (void)writeAudioData:(const void *)ptr length:(int)length
{
  [playingStream write:(void *)ptr length:length];
}

- (void)wait
{
  [playingStream wait];
}

- (void)closeAudio
{
  [playingStream close];
  [playingStream release];
// FIXME: need to release it somewhere
// we're getting delegate messages after we stop playing??
  playingStream = nil;
}

- (void)flush:(int)time
{
}

- (void)pause:(BOOL)p
{
  [playingStream pause:p];
}

- (BOOL)openAudioFormat:(AFormat)fmt rate:(int)rate numChannels:(int)nch;
{
  [playingStream release];
  playingStream = [[SoundStream alloc] init];
  return [playingStream openWithFormat:fmt rate:rate channels:nch];
}

- init
{
  return [super initWithDescription:@"Soundkit Output Driver 0.2"];
}

- (void)getVolumeLeft:(int *)l right:(int *)r
{
  if ( playingStream != nil ) {
    float fl, fr;
  
    [playingStream->myPlayStream getGainLeft:&fl right:&fr];
    *l = fl * 100.0;
    *r = fr * 100.0;
  } else {
    *l = -1;
    *r = -1;
  }
}

- (void)setVolumeLeft:(int )l right:(int)r
{
  if ( playingStream != nil ) {
    float fl, fr;
  
    fl = l / 100.0;
    fr = r / 100.0;
    [playingStream->myPlayStream setGainLeft:fl right:fr];
  }
}

- (BOOL)enabledByDefault
{
  return YES;
}

@end
