/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/
#import <Foundation/Foundation.h>

typedef enum
{
  INPUT_VIS_ANALYZER,INPUT_VIS_SCOPE,INPUT_VIS_VU,INPUT_VIS_OFF
} InputVisType;

typedef enum
{
  FMT_U8,FMT_S8,FMT_U16_LE,FMT_U16_BE,FMT_U16_NE,FMT_S16_LE,FMT_S16_BE,FMT_S16_NE
} AFormat;



@class PlaylistEntry;
@class Output;

@protocol PluginProtocol
// Just used so the bundle loading stuff can tell if a class is a plugin
@end

@interface Plugin : NSObject <PluginProtocol>
{
  NSString *description;
}

- initWithDescription:(NSString *)_description;
- (void)setEnabled:(BOOL)val;
- (BOOL)enabled;
- (NSString *)description;
- (BOOL)hasAbout;
- (BOOL)hasConfigure;
- (void)about;
- (void)configure;

+ (void)loadAllPluginBundles;
+ (void)loadPluginsAtPath:(NSString *)path;
+ (void)updateOutputPlugin;

@end

@interface Input : Plugin

+ (NSArray *)plugins;
+ (void)registerPlugin:(Plugin *)op;

+ (void)playFile:(NSString *)filename;
+ (NSString *)playingFile;
+ (BOOL)isPlaying;
+ (BOOL)isPaused;
+ (int)getTime;
+ (void)stop;
+ (void)pause;
+ (void)setEq;
+ (void)getSongInfo:(NSString *)fileName entry:(PlaylistEntry *)entry;
+ (unsigned char *)getVis:(int)time;
+ (void)addVisTime:(int)time data:(const unsigned char *)data
			     type:(InputVisType)type;
+ (void)addVisPcmTime:(int)time 
	       format:(AFormat)fmt
	  numChannels:(int)numChannels
	      length:(int)length
		data:(void *)data;
+ (InputVisType)getVisType;
+ (void)setInfoTitle:(NSString *)title 
	      length:(int)length
		rate:(int)rate
	   frequency:(int)frequency
	 numChannels:(int)numChannels;
+ (void)setInfoText:(NSString *)text;
+ (void)lockInfoText:(NSString *)text;
+ (void)unlockInfoText;
+ (void)getVolumeLeft:(int *)l right:(int*)r;
+ (void)setVolumeLeft:(int)l right:(int)r;
+ (void)fileInfoBox:(NSString *)filename;
+ (void)updateVolume;
+ (void)donePlaying;

- (void)donePlaying;
- (void)setInfoText:(NSString *)text;
- (void)lockInfoText:(NSString *)text;
- (void)unlockInfoText;
- (BOOL)isOurFile:(NSString *)filename;
- (void)playFile:(NSString *)filename;
- (int)getTime;
- (void)setEq:(BOOL)on preamp:(float)preamp bands:(float *)bands;
- (NSArray *)scanDir:(NSString *)dirname;
- (void)stop;
- (void)pause:(BOOL)paused;
- (void)seek:(int)time;
- (BOOL)getVolumeLeft:(int *)l right:(int*)r;
- (BOOL)setVolumeLeft:(int)l right:(int)r;
- (NSDictionary *)getSongInfoForFile:(NSString *)filename;
- (void)fileInfoBox:(NSString *)filename;
- (BOOL)enabledByDefault;

@end

@interface Output : Plugin

+ (NSArray *)plugins;
+ (void)registerPlugin:(Plugin *)op;
+ (Output *)output;

- (NSString *)description;

- (void)getVolumeLeft:(int *)l right:(int *)r;
- (void)setVolumeLeft:(int )l right:(int)r;
- (BOOL)openAudioFormat:(AFormat )fmt rate:(int)rate numChannels:(int)nch;
- (void)writeAudioData:(const void *)ptr length:(int)length;
- (void)wait;
- (void)closeAudio;
- (void)flush:(int)time;
- (void)pause:(BOOL) paused;
- (int)bufferFree;
- (BOOL)bufferPlaying;
- (int)outputTime;
- (int)writtenTime;

- (BOOL)enabledByDefault;

@end

@interface Effect : Plugin
{
}

+ (void)registerPlugin:(Plugin *)op;
+ (NSArray *)plugins;

- (void)cleanup;

+ (int)modSampleData:(short int *)data
	      length:(int)length
       bitsPerSample:(int)bps
	 numChannels:(int)numChannels
		freq:(int)srate;

- (int)modSampleData:(short int *)data
	      length:(int)length
       bitsPerSample:(int)bps
	 numChannels:(int)numChannels
		freq:(int)srate;

@end

@interface General : Plugin
{
}

+ (void)registerPlugin:(Plugin *)op;
+ (NSArray *)plugins;
@end

extern NSString *SongInfoChangedNotification;
extern NSString *SongEndedNotification;
extern void mysleep(unsigned int microseconds);

