/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/
#import <AppKit/AppKit.h>
#import "NibObject.h"

@class Config;

@interface Preferences : NibObject
{
  id tabView;

  id generalView;
  id inputView;

  NSArray *generalControls;
  NSMutableArray *controlsToConfigKeys;
  Config *tmp_config;

  id o_plugin_popup;
  id o_button_matrix;

  id input_p;
  id effect_p;
  id general_p;
}

- (void)ok:sender;
- (void)cancel:sender;
- (void)defaults:sender;

- (void)valueChanged:sender;

- (void)configureOutputPlugin:sender;
- (void)aboutOutputPlugin:sender;

- (void)o_plugin_action:sender;

- (void)fillPluginLists;

@end


extern NSString *PreferencesChangedNotification;
