/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/
#import "Preferences.h"
#import <AppKit/AppKit.h>
#import "Config.h"
#import "AppDelegate.h"
#import "TabView.h"
#import "PluginPreference.h"

NSString *PreferencesChangedNotification = @"PreferencesChangedNotification";

NSString *keysForTags[] = { 
  @"load", @"snap_distance",
  @"default_extension" 
};
int numKeysForTags = (sizeof (keysForTags) / sizeof (keysForTags[0]));

@interface ControlToConfigKey : NSObject
{
@public
  NSControl *control;
  id key;
}
@end
@implementation ControlToConfigKey
@end
  

@implementation Preferences

- (id)configKeyForControl:(NSControl *)control
{
  int i;
  ControlToConfigKey *ctck;

  for ( i = 0; i < [controlsToConfigKeys count]; i++ ) {
    ctck = [controlsToConfigKeys objectAtIndex:i];
    if ( ctck->control == control )
      return ctck->key;
  }
  return nil;
}

- (void)createButtonsToKeysForObject:view
{
  NSArray *views = nil;
  ControlToConfigKey *ctck;
  int i, tag;
  id key, control;

  if ( [view isKindOfClass:[NSMatrix class]] )
    views = [view cells];
  else if ( [view isKindOfClass:[NSView class]] )
    views = [view subviews];  
  
  for ( i = 0; i < [views count]; i++ ) {
    control = [views objectAtIndex:i];
    [self createButtonsToKeysForObject:control];
    key = nil;
    if ( [control respondsToSelector:@selector(alternateTitle)] ) {
      key = [control alternateTitle];
      [control setAlternateTitle:@""];
    } else if ( [control respondsToSelector:@selector(tag)] ) {
      tag = [control tag];
      if ( tag > 0 && tag <= numKeysForTags )
        key = keysForTags[tag-1];
    }
    if ( key != nil ) {
      ctck = [[ControlToConfigKey alloc] init];
      ctck->key = [key retain];
      ctck->control = control;
      [controlsToConfigKeys addObject:ctck];
    }
  }
}

- (void)setupPreferences
{
  controlsToConfigKeys = [[NSMutableArray array] retain];

  generalView = [tabView tab1];
  inputView = [tabView tab2];

  [self createButtonsToKeysForObject:generalView];

  [self fillPluginLists];

  [input_p setPluings:[Input plugins]];
  [effect_p setPluings:[Effect plugins]];
  [general_p setPluings:[General plugins]];
}

- (void)updateObject:view
{
  NSArray *views = nil;
  int i;
  id control, key, val;

  if ( [view isKindOfClass:[NSMatrix class]] )
    views = [view cells];
  else if ( [view isKindOfClass:[NSView class]] )
    views = [view subviews];  
  
  for ( i = 0; i < [views count]; i++ ) {
    control = [views objectAtIndex:i];
    [self updateObject:control];
    key = [self configKeyForControl:control];
    if ( key != nil ) {
      val = [tmp_config objectForKey:key];
      if ( val != nil ) {
	if ( [control isKindOfClass:[NSButton class]] 
	     || [control isKindOfClass:[NSButtonCell class]] )
	  [control setState:[val isEqualToString:@"YES"]];
	else
	  [control setStringValue:val];
      }
    }
  }
}

- (void)updateDisplay
{
  [self updateObject:generalView];
}

- (void)awakeFromNib
{
  [self setupPreferences];
}

- (void)show:sender
{
  tmp_config = [[cfg copyWithZone:[self zone]] retain];
  [super show:sender];
}

- (void)ok:sender
{
  if ( [cfg close_box_on_left] != [tmp_config close_box_on_left] ) {
    NSRunAlertPanel(PACKAGE, @"You must restart %@ for the settings to take effect.", @"OK", nil, nil, PACKAGE);
  }
  [cfg release];
  cfg = tmp_config;
  tmp_config = nil;
  [window orderOut:self];
  [[NSNotificationCenter defaultCenter]
    postNotificationName:PreferencesChangedNotification object:nil];
  [Output updateOutputPlugin];
  [cfg save_config];
  [[NSApp delegate] resetVisTimer];
}

- (void)cancel:sender
{
  [tmp_config release];
  tmp_config = nil;
  [window orderOut:self];
}

- (void)defaults:sender
{
  [tmp_config release];
  tmp_config = [[Config alloc] init];
  [self updateDisplay];
}

- (void)valueChanged:sender
{
  id key;
  id control;
  
  if ( [sender isKindOfClass:[NSMatrix class]] )
    control = [sender selectedCell];
  else
    control = sender;

  key = [self configKeyForControl:control];
  if ( key != nil ) {
    if ( [control isKindOfClass:[NSButtonCell class]]
	 || [control isKindOfClass:[NSButton class]] )
      [tmp_config setObject:[control state] ? @"YES" : @"NO" forKey:key];
    else if ( [control isKindOfClass:[NSTextField class]] ) {
      [tmp_config setObject:[control stringValue] forKey:key];
    }
  }
}

- (void)configureOutputPlugin:sender
{
  int sel = [o_plugin_popup indexOfSelectedItem];
  
  if ( sel != -1 )
    [[[Output plugins] objectAtIndex:sel] about];
}

- (void)aboutOutputPlugin:sender
{
  int sel = [o_plugin_popup indexOfSelectedItem];
  
  if ( sel != -1 )
    [[[Output plugins] objectAtIndex:sel] about];
}

- (void)o_plugin_action:sender
{
  int sel, i;
  sel = [o_plugin_popup indexOfSelectedItem];
  
  if ( sel != -1 ) {
    for ( i = 0;i < [[Output plugins] count]; i++ )
      [[[Output plugins] objectAtIndex:i] setEnabled:sel == i];
  }
}

- (void)fillPluginLists
{
  NSArray *outputs;
  Output *plugin;
  int i;

  outputs = [Output plugins];
  [o_plugin_popup removeAllItems];

  for ( i = 0; i < [outputs count]; i++ ) {
    plugin = [outputs objectAtIndex:i];
    [o_plugin_popup addItemWithTitle:[plugin description]];
    [[o_plugin_popup itemAtIndex:i] setTag:i];
    if ( [plugin enabled] ) {
      [o_plugin_popup selectItemAtIndex:i];
      [[o_button_matrix cellWithTag:0] setEnabled:[plugin hasConfigure]];
      [[o_button_matrix cellWithTag:1] setEnabled:[plugin hasAbout]];
    }
  }

  [o_plugin_popup synchronizeTitleAndSelectedItem];
}


@end

