/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/
#import "Visualization.h"
#import "Config.h"
#import "Skin.h"

static float vis_afalloff_speeds[]={0.34,0.5,1.0,1.3,1.6};
static float vis_pfalloff_speeds[]={1.1,1.16,1.23,1.3,1.4};
static int vis_redraw_delays[]={1,2,4,8};
static unsigned char vis_scope_colors[]={21,21,20,20,19,19,18,19,19,20,20,21,21};


@implementation Visualization

- initWithFrame:(NSRect)frame
{
  [self clear];
  return [super initWithFrame:frame];
}

- (void)timeout:(unsigned char *)newdata
{
  static NSDate *lastTime = nil;
  NSTimeInterval micros=9999999;
  BOOL falloff = FALSE;
  int i;

#define fourteen_microseconds 0.00014

  if ( lastTime == nil ) {
    lastTime = [[NSDate date] retain];
  } else {
    micros = [[NSDate date] timeIntervalSinceDate:lastTime];
    if(micros > fourteen_microseconds)
      lastTime = [[NSDate date] retain];
  }
	
  if ( [cfg vis_type] == VIS_ANALYZER ) {
    if(micros > fourteen_microseconds)
      falloff = TRUE;
    if(newdata || falloff)	{
      for(i = 0; i < 75; i++) {
	if(newdata && newdata[i] > data[i]) {
	  data[i] = newdata[i];
	  if(data[i] > peak[i])
	    {
	      peak[i]=data[i];
	      peak_speed[i]=0.05;
	      
	    }
	  else if(peak[i]>0.0)
	    {
	      peak[i] -= peak_speed[i];
	      peak_speed[i] *= vis_pfalloff_speeds[[cfg peaks_falloff]];
	      if(peak[i] < data[i])
		peak[i] = data[i];
	      if(peak[i] < 0.0)
		peak[i] = 0.0;
	    }
	}
	else if(falloff)
	  {
	    if(data[i]>0.0)
	      {
		data[i] -= vis_afalloff_speeds[[cfg analyzer_falloff]];
		if(data[i] < 0.0)
		  data[i] = 0.0;
	      }
	    if(peak[i] > 0.0)
	      {
		peak[i] -= peak_speed[i];
		peak_speed[i] *= vis_pfalloff_speeds[[cfg peaks_falloff]];
		if ( peak[i] < data[i] )
		  peak[i] = data[i];
		if ( peak[i] < 0.0 )
		  peak[i] = 0.0;
	      }
	  }
      }
    }
  } else if(data)  {
    for(i = 0; i < 75; i++)
      data[i] = newdata[i];
  }
#if 1
  if(micros>fourteen_microseconds)
    {
      if(!refresh_delay)
	{
	  [self drawIt];
	  [self setNeedsDisplay:YES];
	  refresh_delay = vis_redraw_delays[[cfg vis_refresh]];
	  
	}
      refresh_delay--;
    }
#else
//  [self  setNeedsDisplay:YES];
  [self drawIt];
#endif
}

#define set_byte(data, x, y, coloridx) \
{ \
  *(data[0]+(76*y)+x) = currentSkin->vis_color[coloridx][0];\
  *(data[1]+(76*y)+x) = currentSkin->vis_color[coloridx][1];\
  *(data[2]+(76*y)+x) = currentSkin->vis_color[coloridx][2];\
}

#define set_byteoff(data, off, coloridx)\
{\
  *(data[0]+off) = currentSkin->vis_color[coloridx][0];\
  *(data[1]+off) = currentSkin->vis_color[coloridx][1];\
  *(data[2]+off) = currentSkin->vis_color[coloridx][2];\
}

#if 1
- (void)drawRect:(NSRect)rect
{
  [self drawIt];
}

- (void)drawIt
{
  int x,y,h=0,h2;
  unsigned char *ptr,c;
  NSRect frame = [self frame];
  int bit_width = 76; //(7 + (frame.size.width * 8)) / 8;
  int bit_size = sizeof(unsigned char)*bit_width*frame.size.height;
  static unsigned char *bit_data[3] = {0,0,0};
  int off = 0;
  Skin *skin;


  if ( bit_data[0] == 0 ) {
    bit_data[0] = malloc(bit_size);
    bit_data[1] = malloc(bit_size);
    bit_data[2] = malloc(bit_size);
  }

  skin = currentSkin;

  memset(bit_data[0], skin->vis_color[0][0], bit_size);
  memset(bit_data[1], skin->vis_color[0][1], bit_size);
  memset(bit_data[2], skin->vis_color[0][2], bit_size);  

#if 1

  for(y=1;y<16;y+=2) {
    for(x=0;x<76;x+=2,ptr+=2)
      set_byte(bit_data, x, y, 1);
  }	

  if([cfg vis_type] == VIS_ANALYZER) {
    for(x=0;x<75;x++) {
      if(([cfg analyzer_type] == ANALYZER_BARS&&(x%4)==0)
	 ||[cfg analyzer_type] == ANALYZER_LINES)
	h=(int)data[x];
      
      if(h&&([cfg analyzer_type]==ANALYZER_LINES||(x%4)!=3)) {
	off = ((16-h)*bit_width)+x;
	switch([cfg analyzer_mode]) {
	case	ANALYZER_NORMAL:		
	  for(y=0;y<h;y++,off+=bit_width)
	    set_byteoff(bit_data, off, 18-h+y);
	  break;
	case	ANALYZER_FIRE:
	  for(y=0;y<h;y++,off+=bit_width)
	    set_byteoff(bit_data, off, y+2);
	  break;
	case	ANALYZER_VLINES:
	  for(y=0;y<h;y++,off+=bit_width)
	    set_byteoff(bit_data, off, 18-h);
	  break;
	}
      }
    }
    if([cfg analyzer_peaks]) {
      for(x=0;x<75;x++)	{
	if(([cfg analyzer_type] == ANALYZER_BARS&&(x%4)==0)
	   ||[cfg analyzer_type] == ANALYZER_LINES)
	  h=(int)peak[x];
	if(h&&([cfg analyzer_type] == ANALYZER_LINES||(x%4)!=3))
	  set_byteoff(bit_data, (16-h)*bit_width+x, 23);
      }
    }
  } else if([cfg vis_type] == VIS_SCOPE) {
    for(x=0;x<75;x++) {
      switch([cfg scope_mode]) {
      case	SCOPE_DOT:
	h=(int)data[x];
	set_byteoff(bit_data, ((15-h)*bit_width)+x, vis_scope_colors[h]);
	break;
      case	SCOPE_LINE:
	if(x!=74) {
	  h=15-(int)data[x];
	  h2=15-(int)data[x+1];
	  if(h>h2) {
	    y=h;
	    h=h2;
	    h2=y;
	  }
	  off = (h*bit_width)+x;
	  for(y=h;y<=h2;y++,off+=bit_width)
	    set_byteoff(bit_data, off, vis_scope_colors[y-3]);
	} else {
	  h=15-(int)data[x];
	  set_byteoff(bit_data, (h*bit_width)+x, vis_scope_colors[h]);
	}
	break;
      case	SCOPE_SOLID:
	h=15-(int)data[x];
	h2=9;
	c=vis_scope_colors[(int)data[x]];
	if(h>h2) {
	  y=h;
	  h=h2;
	  h2=y;
	}
	off=(h*bit_width)+x;
	for(y=h;y<=h2;y++,off+=bit_width)
	  set_byteoff(bit_data, off, c);
	break;
      }
    }
  }
#endif

  if ( [self lockFocusIfCanDraw] ) {
    NSDrawBitmap(NSMakeRect(0, 0, frame.size.width, frame.size.height),
		 frame.size.width, frame.size.height, 8, 3, 8, bit_width,
		 YES, NO, NSDeviceRGBColorSpace, bit_data);
    [self unlockFocus];
  }

}
#endif

- (void)clear
{
  int i;
  
  for(i=0;i<75;i++) {
    data[i] = ([cfg vis_type] == VIS_SCOPE) ? 6 : 0;
    peak[i]=0;
  }
}


@end


@implementation VisEntry
@end
