
#import "LayerProtocol.h"
#import "ActionData.h"
#import "PixelSource.h"


@class MutableIntensityMap, Mask;


@interface Action: NSObject <PixelSource>
{
	id <PixelSource>	 	 source;
	id <PixelSource>	 	 ground;
	id <PixelDestination>	 destination;
	Mask					*mask;
	id <Layer>	   	 	 layer;

	NSMutableData		*rowData, *srcData, *mskData;
	RGBAPixel			*rowRGBA, *srcRGBA;
	CMYKAPixel		*rowCMYKA, *srcCMYKA;
	uchar			*msk;
	BOOL				 isCMYKA, wantsRow;
	BOOL				 ignoreMask, brushMode;

	int				 pixelsWide, pixelsHigh;

	CompositingMethod	 compositing;
	FilteringMethod	 filtering;
	BoundsType		 boundsType;
	int				 intensity;

	NSTimeInterval		 aTime, cTime, fTime, iTime;
	NSTimeInterval		 mTime, oTime, rTime, wTime;
	int				 timeCount;
}

- initWithEngineData: (ActionData *)data;	// see example

// messages before launch - message super FIRST
- (void)preLaunchMainThread;
- (void)preLaunchExecThread;

// messages before engine ends - message super LAST
- (void)postEndExecThread;
- (void)postEndMainThread;

// Starting point for brushing
- (void)brushDownAt: (NSPoint)point;

// see example
- (void)getRGBAPixel: (RGBAPixel *)p  at: (int)x: (int)y  count: (int)n;
- (void)getCMYKAPixel: (CMYKAPixel *)p  at: (int)x: (int)y  count: (int)n;

// returns dpi of processed layer
- (double)dpi;

// returns size of layer, in pixels
- (int)width;
- (int)height;

// YES if layer in CMYK color space, NO otherwise
- (BOOL)isCMYKA;

- (void)getMarqueeBounds: (int *)minX: (int *)minY: (int *)maxX: (int *)maxY;
- (void)getLayerBounds: (int *)minX: (int *)minY: (int *)maxX: (int *)maxY;
- (void)getDocumentBounds: (int *)minX: (int *)minY: (int *)maxX: (int *)maxY;
- (void)getBounds: (int *)minX: (int *)minY: (int *)maxX: (int *)maxY;

@end
