#import "Action.h"


#define TRANSFERCOMPONENTS  (8)

enum { RED,GREEN,BLUE, ALPHA, CYAN,MAGENTA,YELLOW,BLACK };


@interface ChannelMapAction: Action
{
	int	red[CHANNEL_MAX+1];
	int	green[CHANNEL_MAX+1];
	int	blue[CHANNEL_MAX+1];
	int	alpha[CHANNEL_MAX+1];
	int	cyan[CHANNEL_MAX+1];
	int	magenta[CHANNEL_MAX+1];
	int	yellow[CHANNEL_MAX+1];
	int	black[CHANNEL_MAX+1];

	uchar	*directData;
	BOOL		 directAccess;
	BOOL		 directHasAlpha;
	int		 directBytesPerRow;
	int		 directBytesPerPixel;
	int		 directWidth;
	int		 directHeight;
}

- initWithEngineData: (ActionData *)data;

- (void)preLaunchExecThread;

- (void)copyRGBmeshed: (int)x: (int)y  count: (int)n;
- (void)copyRGBAmeshed: (int)x: (int)y  count: (int)n;
- (void)copyRGBmeshed: (int)x: (int)y  count: (int)n  mask: (uchar *)m;
- (void)copyRGBAmeshed: (int)x: (int)y  count: (int)n  mask: (uchar *)m;

- (void)copyCMYKmeshed: (int)x: (int)y  count: (int)n;
- (void)copyCMYKAmeshed: (int)x: (int)y  count: (int)n;
- (void)copyCMYKmeshed: (int)x: (int)y  count: (int)n  mask: (uchar *)m;
- (void)copyCMYKAmeshed: (int)x: (int)y  count: (int)n  mask: (uchar *)m;

- (void)compositeRow: (int)y;

- (void)getTransferFunction: (double *)y  at: (double)x;

- (void)getRGBAPixel: (RGBAPixel *)p  at: (int)x: (int)y  count: (int)n;
- (void)getCMYKAPixel: (CMYKAPixel *)p  at: (int)x: (int)y  count: (int)n;

@end
